/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosKeyCredential;
import com.azure.cosmos.implementation.AuthorizationTokenProvider;
import com.azure.cosmos.implementation.PathInfo;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.ResourceId;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.RequestVerb;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BaseAuthorizationTokenProvider
implements AuthorizationTokenProvider {
    private static final String AUTH_PREFIX = "type=master&ver=1.0&sig=";
    private final CosmosKeyCredential cosmosKeyCredential;
    private final Mac macInstance;
    private int masterKeyHashCode;

    public BaseAuthorizationTokenProvider(CosmosKeyCredential cosmosKeyCredential) {
        this.cosmosKeyCredential = cosmosKeyCredential;
        this.macInstance = this.getMacInstance();
    }

    private static String getResourceSegment(ResourceType resourceType) {
        switch (resourceType) {
            case Attachment: {
                return "attachments";
            }
            case Database: {
                return "dbs";
            }
            case Conflict: {
                return "conflicts";
            }
            case Document: {
                return "docs";
            }
            case DocumentCollection: {
                return "colls";
            }
            case Offer: {
                return "offers";
            }
            case Permission: {
                return "permissions";
            }
            case StoredProcedure: {
                return "sprocs";
            }
            case Trigger: {
                return "triggers";
            }
            case UserDefinedFunction: {
                return "udfs";
            }
            case User: {
                return "users";
            }
            case PartitionKeyRange: {
                return "pkranges";
            }
            case Media: {
                return "media";
            }
            case DatabaseAccount: {
                return "";
            }
        }
        return null;
    }

    @Override
    public String generateKeyAuthorizationSignature(RequestVerb verb, String resourceIdOrFullName, ResourceType resourceType, Map<String, String> headers) {
        return this.generateKeyAuthorizationSignature(verb, resourceIdOrFullName, BaseAuthorizationTokenProvider.getResourceSegment(resourceType), headers);
    }

    public String generateKeyAuthorizationSignature(RequestVerb verb, String resourceIdOrFullName, String resourceSegment, Map<String, String> headers) {
        if (verb == null) {
            throw new IllegalArgumentException("verb");
        }
        if (resourceIdOrFullName == null) {
            resourceIdOrFullName = "";
        }
        if (resourceSegment == null) {
            throw new IllegalArgumentException("resourceSegment");
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        if (StringUtils.isEmpty(this.cosmosKeyCredential.getKey())) {
            throw new IllegalArgumentException("key credentials cannot be empty");
        }
        if (!PathsHelper.isNameBased(resourceIdOrFullName)) {
            resourceIdOrFullName = resourceIdOrFullName.toLowerCase(Locale.ROOT);
        }
        StringBuilder body = new StringBuilder();
        body.append(ModelBridgeInternal.toLower(verb)).append('\n').append(resourceSegment).append('\n').append(resourceIdOrFullName).append('\n');
        if (headers.containsKey("x-ms-date")) {
            body.append(headers.get("x-ms-date").toLowerCase(Locale.ROOT));
        }
        body.append('\n');
        if (headers.containsKey("date")) {
            body.append(headers.get("date").toLowerCase(Locale.ROOT));
        }
        body.append('\n');
        Mac mac = this.getMacInstance();
        byte[] digest = mac.doFinal(body.toString().getBytes(StandardCharsets.UTF_8));
        String auth = Utils.encodeBase64String(digest);
        return AUTH_PREFIX + auth;
    }

    @Override
    public String getAuthorizationTokenUsingResourceTokens(Map<String, String> resourceTokens, String path, String resourceId) {
        if (resourceTokens == null) {
            throw new IllegalArgumentException("resourceTokens");
        }
        String resourceToken = null;
        if (resourceTokens.containsKey(resourceId) && resourceTokens.get(resourceId) != null) {
            resourceToken = resourceTokens.get(resourceId);
        } else if (StringUtils.isEmpty(path) || StringUtils.isEmpty(resourceId)) {
            if (resourceTokens.size() > 0) {
                resourceToken = resourceTokens.values().iterator().next();
            }
        } else {
            String[] pathParts = StringUtils.split(path, "/");
            String[] resourceTypes = new String[]{"dbs", "colls", "docs", "sprocs", "udfs", "triggers", "users", "permissions", "attachments", "media", "conflicts"};
            HashSet resourceTypesSet = new HashSet();
            Collections.addAll(resourceTypesSet, resourceTypes);
            for (int i = pathParts.length - 1; i >= 0; --i) {
                if (resourceTypesSet.contains(pathParts[i]) || !resourceTokens.containsKey(pathParts[i])) continue;
                resourceToken = resourceTokens.get(pathParts[i]);
            }
        }
        return resourceToken;
    }

    public String generateKeyAuthorizationSignature(RequestVerb verb, URI uri, Map<String, String> headers) {
        if (verb == null) {
            throw new IllegalArgumentException(String.format("STRING agument %s is null or empty", "verb"));
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri");
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        PathInfo pathInfo = new PathInfo(false, "", "", false);
        this.getResourceTypeAndIdOrFullName(uri, pathInfo);
        return this.generateKeyAuthorizationSignatureNew(verb, pathInfo.resourceIdOrFullName, pathInfo.resourcePath, headers);
    }

    private String generateKeyAuthorizationSignatureNew(RequestVerb verb, String resourceIdValue, String resourceType, Map<String, String> headers) {
        if (verb == null) {
            throw new IllegalArgumentException(String.format("STRING agument %s is null or empty", "verb"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("STRING agument %s is null or empty", "resourceType"));
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        String authResourceId = this.getAuthorizationResourceIdOrFullName(resourceType, resourceIdValue);
        String payLoad = this.generateMessagePayload(verb, authResourceId, resourceType, headers);
        Mac mac = this.getMacInstance();
        byte[] digest = mac.doFinal(payLoad.getBytes(StandardCharsets.UTF_8));
        String authorizationToken = Utils.encodeBase64String(digest);
        String authtoken = AUTH_PREFIX + authorizationToken;
        return HttpUtils.urlEncode(authtoken);
    }

    private Mac getMacInstance() {
        int masterKeyLatestHashCode = BridgeInternal.getHashCode(this.cosmosKeyCredential);
        if (masterKeyLatestHashCode != this.masterKeyHashCode) {
            byte[] masterKeyBytes = this.cosmosKeyCredential.getKey().getBytes(StandardCharsets.UTF_8);
            byte[] masterKeyDecodedBytes = Utils.Base64Decoder.decode(masterKeyBytes);
            SecretKeySpec signingKey = new SecretKeySpec(masterKeyDecodedBytes, "HMACSHA256");
            try {
                Mac macInstance = Mac.getInstance("HMACSHA256");
                macInstance.init(signingKey);
                this.masterKeyHashCode = masterKeyLatestHashCode;
                return macInstance;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            return (Mac)this.macInstance.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    private String generateMessagePayload(RequestVerb verb, String resourceId, String resourceType, Map<String, String> headers) {
        String xDate = headers.get("x-ms-date");
        String date = headers.get("date");
        if (StringUtils.isEmpty(xDate) && (StringUtils.isEmpty(date) || StringUtils.isWhitespace(date))) {
            headers.put("x-ms-date", Utils.nowAsRFC1123());
            xDate = Utils.nowAsRFC1123();
        }
        if (!PathsHelper.isNameBased(resourceId)) {
            resourceId = resourceId.toLowerCase(Locale.ROOT);
        }
        StringBuilder payload = new StringBuilder();
        payload.append(ModelBridgeInternal.toLower(verb)).append('\n').append(resourceType.toLowerCase(Locale.ROOT)).append('\n').append(resourceId).append('\n').append(xDate.toLowerCase(Locale.ROOT)).append('\n').append(StringUtils.isEmpty(xDate) ? date.toLowerCase(Locale.ROOT) : "").append('\n');
        return payload.toString();
    }

    private String getAuthorizationResourceIdOrFullName(String resourceType, String resourceIdOrFullName) {
        if (StringUtils.isEmpty(resourceType) || StringUtils.isEmpty(resourceIdOrFullName)) {
            return resourceIdOrFullName;
        }
        if (PathsHelper.isNameBased(resourceIdOrFullName)) {
            return resourceIdOrFullName;
        }
        if (resourceType.equalsIgnoreCase("offers") || resourceType.equalsIgnoreCase("partitions") || resourceType.equalsIgnoreCase("topology") || resourceType.equalsIgnoreCase("ridranges")) {
            return resourceIdOrFullName;
        }
        ResourceId parsedRId = ResourceId.parse(resourceIdOrFullName);
        if (resourceType.equalsIgnoreCase("dbs")) {
            return parsedRId.getDatabaseId().toString();
        }
        if (resourceType.equalsIgnoreCase("users")) {
            return parsedRId.getUserId().toString();
        }
        if (resourceType.equalsIgnoreCase("colls")) {
            return parsedRId.getDocumentCollectionId().toString();
        }
        if (resourceType.equalsIgnoreCase("docs")) {
            return parsedRId.getDocumentId().toString();
        }
        return resourceIdOrFullName;
    }

    private void getResourceTypeAndIdOrFullName(URI uri, PathInfo pathInfo) {
        if (uri == null) {
            throw new IllegalArgumentException("uri");
        }
        pathInfo.resourcePath = "";
        pathInfo.resourceIdOrFullName = "";
        String[] segments = StringUtils.split(uri.toString(), "/");
        if (segments == null || segments.length < 1) {
            throw new IllegalArgumentException("InvalidUrl");
        }
        String pathAndQuery = "";
        if (StringUtils.isNotEmpty(uri.getPath())) {
            pathAndQuery = pathAndQuery + uri.getPath();
        }
        if (StringUtils.isNotEmpty(uri.getQuery())) {
            pathAndQuery = pathAndQuery + "?";
            pathAndQuery = pathAndQuery + uri.getQuery();
        }
        if (!PathsHelper.tryParsePathSegments(pathAndQuery, pathInfo, null)) {
            pathInfo.resourcePath = "";
            pathInfo.resourceIdOrFullName = "";
        }
    }
}

