/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.implementation.CosmosItemProperties;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.LeaseStore;
import com.azure.cosmos.implementation.changefeed.RequestOptionsFactory;
import com.azure.cosmos.implementation.changefeed.ServiceItemLease;
import com.azure.cosmos.implementation.changefeed.implementation.BootstrapperImpl;
import com.azure.cosmos.models.AccessCondition;
import com.azure.cosmos.models.AccessConditionType;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.PartitionKey;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class DocumentServiceLeaseStore
implements LeaseStore {
    private final Logger logger = LoggerFactory.getLogger(BootstrapperImpl.class);
    private ChangeFeedContextClient client;
    private String containerNamePrefix;
    private CosmosAsyncContainer leaseCollectionLink;
    private RequestOptionsFactory requestOptionsFactory;
    private volatile String lockETag;

    public DocumentServiceLeaseStore(ChangeFeedContextClient client, String containerNamePrefix, CosmosAsyncContainer leaseCollectionLink, RequestOptionsFactory requestOptionsFactory) {
        this.client = client;
        this.containerNamePrefix = containerNamePrefix;
        this.leaseCollectionLink = leaseCollectionLink;
        this.requestOptionsFactory = requestOptionsFactory;
    }

    @Override
    public Mono<Boolean> isInitialized() {
        String markerDocId = this.getStoreMarkerName();
        CosmosItemProperties doc = new CosmosItemProperties();
        doc.setId(markerDocId);
        CosmosItemRequestOptions requestOptions = this.requestOptionsFactory.createRequestOptions(ServiceItemLease.fromDocument(doc));
        return this.client.readItem(markerDocId, new PartitionKey(markerDocId), requestOptions, CosmosItemProperties.class).flatMap(documentResourceResponse -> Mono.just((Object)(BridgeInternal.getProperties(documentResourceResponse) != null ? 1 : 0))).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)((Object)((Object)throwable))).getStatusCode() == 404) {
                this.logger.info("Lease synchronization document not found");
                return Mono.just((Object)false);
            }
            this.logger.error("Unexpected exception thrown", throwable);
            return Mono.error((Throwable)throwable);
        });
    }

    @Override
    public Mono<Boolean> markInitialized() {
        String markerDocId = this.getStoreMarkerName();
        CosmosItemProperties containerDocument = new CosmosItemProperties();
        containerDocument.setId(markerDocId);
        return this.client.createItem(this.leaseCollectionLink, containerDocument, new CosmosItemRequestOptions(), false).map(item -> true).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)((Object)((Object)throwable))).getStatusCode() == 409) {
                this.logger.info("Lease synchronization document was created by a different instance");
                return Mono.just((Object)true);
            }
            this.logger.error("Unexpected exception thrown", throwable);
            return Mono.just((Object)false);
        });
    }

    @Override
    public Mono<Boolean> acquireInitializationLock(Duration lockExpirationTime) {
        String lockId = this.getStoreLockName();
        CosmosItemProperties containerDocument = new CosmosItemProperties();
        containerDocument.setId(lockId);
        BridgeInternal.setProperty(containerDocument, "ttl", Long.valueOf(lockExpirationTime.getSeconds()).intValue());
        return this.client.createItem(this.leaseCollectionLink, containerDocument, new CosmosItemRequestOptions(), false).map(documentResourceResponse -> {
            if (BridgeInternal.getProperties(documentResourceResponse) != null) {
                this.lockETag = BridgeInternal.getProperties(documentResourceResponse).getETag();
                return true;
            }
            return false;
        }).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)((Object)((Object)throwable))).getStatusCode() == 409) {
                this.logger.info("Lease synchronization document was acquired by a different instance");
                return Mono.just((Object)false);
            }
            this.logger.error("Unexpected exception thrown", throwable);
            return Mono.error((Throwable)throwable);
        });
    }

    @Override
    public Mono<Boolean> releaseInitializationLock() {
        String lockId = this.getStoreLockName();
        CosmosItemProperties doc = new CosmosItemProperties();
        doc.setId(lockId);
        CosmosItemRequestOptions requestOptions = this.requestOptionsFactory.createRequestOptions(ServiceItemLease.fromDocument(doc));
        if (requestOptions == null) {
            requestOptions = new CosmosItemRequestOptions();
        }
        AccessCondition accessCondition = new AccessCondition();
        accessCondition.setType(AccessConditionType.IF_MATCH);
        accessCondition.setCondition(this.lockETag);
        requestOptions.setAccessCondition(accessCondition);
        return this.client.deleteItem(lockId, new PartitionKey(lockId), requestOptions).map(documentResourceResponse -> {
            if (documentResourceResponse.getItem() != null) {
                this.lockETag = null;
                return true;
            }
            return false;
        }).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)((Object)((Object)throwable))).getStatusCode() == 409) {
                this.logger.info("Lease synchronization document was acquired by a different instance");
                return Mono.just((Object)false);
            }
            this.logger.error("Unexpected exception thrown", throwable);
            return Mono.error((Throwable)throwable);
        });
    }

    private String getStoreMarkerName() {
        return this.containerNamePrefix + ".info";
    }

    private String getStoreLockName() {
        return this.containerNamePrefix + ".lock";
    }
}

