/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.IAuthorizationTokenProvider;
import com.azure.cosmos.implementation.SessionContainer;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.directconnectivity.HttpTransportClient;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.Protocol;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.SharedTransportClient;
import com.azure.cosmos.implementation.directconnectivity.StoreClient;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import java.time.Duration;

public class StoreClientFactory
implements AutoCloseable {
    private final Configs configs;
    private final int maxConcurrentConnectionOpenRequests;
    private final Duration requestTimeout;
    private final Protocol protocol;
    private final TransportClient transportClient;
    private final boolean enableTransportClientSharing;
    private volatile boolean isClosed;

    public StoreClientFactory(Configs configs, Duration requestTimeout, int maxConcurrentConnectionOpenRequests, UserAgentContainer userAgent, boolean enableTransportClientSharing) {
        this.configs = configs;
        this.protocol = configs.getProtocol();
        this.requestTimeout = requestTimeout;
        this.maxConcurrentConnectionOpenRequests = maxConcurrentConnectionOpenRequests;
        this.enableTransportClientSharing = enableTransportClientSharing;
        if (enableTransportClientSharing) {
            this.transportClient = SharedTransportClient.getOrCreateInstance(this.protocol, configs, requestTimeout, userAgent);
        } else if (this.protocol == Protocol.HTTPS) {
            this.transportClient = new HttpTransportClient(configs, requestTimeout, userAgent);
        } else if (this.protocol == Protocol.TCP) {
            this.transportClient = new RntbdTransportClient(configs, requestTimeout, userAgent);
        } else {
            throw new IllegalArgumentException(String.format("protocol: %s", new Object[]{this.protocol}));
        }
    }

    @Override
    public void close() throws Exception {
        this.transportClient.close();
        this.isClosed = true;
    }

    public StoreClient createStoreClient(IAddressResolver addressResolver, SessionContainer sessionContainer, GatewayServiceConfigurationReader serviceConfigurationReader, IAuthorizationTokenProvider authorizationTokenProvider, boolean useMultipleWriteLocations) {
        this.throwIfClosed();
        return new StoreClient(this.configs, addressResolver, sessionContainer, serviceConfigurationReader, authorizationTokenProvider, this.transportClient, useMultipleWriteLocations);
    }

    private void throwIfClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("storeClient already closed!");
        }
    }
}

