/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micrometer.core.instrument.Tag;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import java.net.SocketAddress;
import java.net.URI;
import java.util.stream.Stream;

public interface RntbdEndpoint
extends AutoCloseable {
    public int channelsAcquired();

    public int channelsAvailable();

    public int concurrentRequests();

    public long id();

    public boolean isClosed();

    public SocketAddress remoteAddress();

    public int requestQueueLength();

    public Tag tag();

    public long usedDirectMemory();

    public long usedHeapMemory();

    @Override
    public void close();

    public RntbdRequestRecord request(RntbdRequestArgs var1);

    public static final class Config {
        private final PooledByteBufAllocator allocator;
        private final RntbdTransportClient.Options options;
        private final SslContext sslContext;
        private final LogLevel wireLogLevel;

        public Config(RntbdTransportClient.Options options, SslContext sslContext, LogLevel wireLogLevel) {
            Preconditions.checkNotNull(options, "options");
            Preconditions.checkNotNull(sslContext, "sslContext");
            int directArenaCount = PooledByteBufAllocator.defaultNumDirectArena();
            int heapArenaCount = PooledByteBufAllocator.defaultNumHeapArena();
            int pageSize = options.bufferPageSize();
            int maxOrder = Integer.numberOfTrailingZeros(options.maxBufferCapacity()) - Integer.numberOfTrailingZeros(pageSize);
            this.allocator = new PooledByteBufAllocator(heapArenaCount, directArenaCount, pageSize, maxOrder);
            this.options = options;
            this.sslContext = sslContext;
            this.wireLogLevel = wireLogLevel;
        }

        @JsonIgnore
        public PooledByteBufAllocator allocator() {
            return this.allocator;
        }

        @JsonProperty
        public int bufferPageSize() {
            return this.options.bufferPageSize();
        }

        @JsonProperty
        public int connectionTimeoutInMillis() {
            long value = this.options.connectionTimeout().toMillis();
            assert (value <= Integer.MAX_VALUE);
            return (int)value;
        }

        @JsonProperty
        public long idleConnectionTimeoutInNanos() {
            return this.options.idleChannelTimeout().toNanos();
        }

        @JsonProperty
        public long idleEndpointTimeoutInNanos() {
            return this.options.idleEndpointTimeout().toNanos();
        }

        @JsonProperty
        public int maxBufferCapacity() {
            return this.options.maxBufferCapacity();
        }

        @JsonProperty
        public int maxChannelsPerEndpoint() {
            return this.options.maxChannelsPerEndpoint();
        }

        @JsonProperty
        public int maxRequestsPerChannel() {
            return this.options.maxRequestsPerChannel();
        }

        @JsonProperty
        public long receiveHangDetectionTimeInNanos() {
            return this.options.receiveHangDetectionTime().toNanos();
        }

        @JsonProperty
        public long requestTimeoutInNanos() {
            return this.options.requestTimeout().toNanos();
        }

        @JsonProperty
        public long requestTimerResolutionInNanos() {
            return this.options.requestTimerResolution().toNanos();
        }

        @JsonProperty
        public long sendHangDetectionTimeInNanos() {
            return this.options.sendHangDetectionTime().toNanos();
        }

        @JsonProperty
        public long shutdownTimeoutInNanos() {
            return this.options.shutdownTimeout().toNanos();
        }

        @JsonIgnore
        public SslContext sslContext() {
            return this.sslContext;
        }

        @JsonProperty
        public UserAgentContainer userAgent() {
            return this.options.userAgent();
        }

        @JsonProperty
        public LogLevel wireLogLevel() {
            return this.wireLogLevel;
        }

        public String toString() {
            return RntbdObjectMapper.toString(this);
        }
    }

    public static interface Provider
    extends AutoCloseable {
        @Override
        public void close();

        public Config config();

        public int count();

        public int evictions();

        public RntbdEndpoint get(URI var1);

        public Stream<RntbdEndpoint> list();
    }
}

