/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.ReactorNettyRequestRecord;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import reactor.core.publisher.Flux;

public class HttpRequest {
    private HttpMethod httpMethod;
    private URI uri;
    private int port;
    private HttpHeaders headers;
    private Flux<ByteBuf> body;
    private ReactorNettyRequestRecord reactorNettyRequestRecord;

    public HttpRequest(HttpMethod httpMethod, URI uri, int port, HttpHeaders httpHeaders) {
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.port = port;
        this.headers = httpHeaders;
        this.reactorNettyRequestRecord = this.createReactorNettyRequestRecord();
    }

    public HttpRequest(HttpMethod httpMethod, String uri, int port) throws URISyntaxException {
        this.httpMethod = httpMethod;
        this.uri = new URI(uri);
        this.port = port;
        this.headers = new HttpHeaders();
        this.reactorNettyRequestRecord = this.createReactorNettyRequestRecord();
    }

    public HttpRequest(HttpMethod httpMethod, URI uri, int port, HttpHeaders headers, Flux<ByteBuf> body) {
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.port = port;
        this.headers = headers;
        this.body = body;
        this.reactorNettyRequestRecord = this.createReactorNettyRequestRecord();
    }

    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    public HttpRequest withHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public int port() {
        return this.port;
    }

    public HttpRequest withPort(int port) {
        this.port = port;
        return this;
    }

    public URI uri() {
        return this.uri;
    }

    public HttpRequest withUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public HttpRequest withHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequest withHeader(String name, String value) {
        this.headers.set(name, value);
        return this;
    }

    public Flux<ByteBuf> body() {
        return this.body;
    }

    public HttpRequest withBody(String content) {
        byte[] bodyBytes = content.getBytes(StandardCharsets.UTF_8);
        return this.withBody(bodyBytes);
    }

    public HttpRequest withBody(byte[] content) {
        this.headers.set("Content-Length", String.valueOf(content.length));
        return this.withBody((Flux<ByteBuf>)Flux.defer(() -> Flux.just((Object)Unpooled.wrappedBuffer((byte[])content))));
    }

    public HttpRequest withBody(Flux<ByteBuf> content) {
        this.body = content;
        return this;
    }

    public void setReactorNettyRequestRecord(ReactorNettyRequestRecord reactorNettyRequestRecord) {
        this.reactorNettyRequestRecord = reactorNettyRequestRecord;
    }

    public ReactorNettyRequestRecord getReactorNettyRequestRecord() {
        return this.reactorNettyRequestRecord;
    }

    private ReactorNettyRequestRecord createReactorNettyRequestRecord() {
        ReactorNettyRequestRecord reactorNettyRequestRecord = new ReactorNettyRequestRecord();
        reactorNettyRequestRecord.setTimeCreated(OffsetDateTime.now());
        return reactorNettyRequestRecord;
    }
}

