/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.Undefined;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.QueryItem;
import com.azure.cosmos.implementation.query.aggregation.AggregateOperator;
import com.azure.cosmos.implementation.query.aggregation.Aggregator;
import com.azure.cosmos.implementation.query.aggregation.AverageAggregator;
import com.azure.cosmos.implementation.query.aggregation.CountAggregator;
import com.azure.cosmos.implementation.query.aggregation.MaxAggregator;
import com.azure.cosmos.implementation.query.aggregation.MinAggregator;
import com.azure.cosmos.implementation.query.aggregation.SumAggregator;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class AggregateDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionComponent<T> {
    private IDocumentQueryExecutionComponent<T> component;
    private Aggregator aggregator;
    private ConcurrentMap<String, QueryMetrics> queryMetricsMap = new ConcurrentHashMap<String, QueryMetrics>();

    public AggregateDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, Collection<AggregateOperator> aggregateOperators) {
        this.component = component;
        AggregateOperator aggregateOperator = aggregateOperators.iterator().next();
        switch (aggregateOperator) {
            case Average: {
                this.aggregator = new AverageAggregator();
                break;
            }
            case Count: {
                this.aggregator = new CountAggregator();
                break;
            }
            case Max: {
                this.aggregator = new MaxAggregator();
                break;
            }
            case Min: {
                this.aggregator = new MinAggregator();
                break;
            }
            case Sum: {
                this.aggregator = new SumAggregator();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + aggregateOperator.toString());
            }
        }
    }

    @Override
    public Flux<FeedResponse<T>> drainAsync(int maxPageSize) {
        return this.component.drainAsync(maxPageSize).collectList().map(superList -> {
            double requestCharge = 0.0;
            ArrayList<Document> aggregateResults = new ArrayList<Document>();
            HashMap<String, String> headers = new HashMap<String, String>();
            for (FeedResponse page : superList) {
                if (page.getResults().size() == 0) {
                    headers.put("x-ms-request-charge", Double.toString(requestCharge));
                    FeedResponse frp = BridgeInternal.createFeedResponse(aggregateResults, headers);
                    return frp;
                }
                Document doc = (Document)page.getResults().get(0);
                requestCharge += page.getRequestCharge();
                QueryItem values = new QueryItem(doc.toJson());
                this.aggregator.aggregate(values.getItem());
                for (String key : BridgeInternal.queryMetricsFromFeedResponse(page).keySet()) {
                    if (this.queryMetricsMap.containsKey(key)) {
                        QueryMetrics qm = (QueryMetrics)BridgeInternal.queryMetricsFromFeedResponse(page).get(key);
                        ((QueryMetrics)this.queryMetricsMap.get(key)).add(qm);
                        continue;
                    }
                    this.queryMetricsMap.put(key, (QueryMetrics)BridgeInternal.queryMetricsFromFeedResponse(page).get(key));
                }
            }
            if (this.aggregator.getResult() == null || !this.aggregator.getResult().equals(Undefined.value())) {
                Document aggregateDocument = new Document();
                BridgeInternal.setProperty(aggregateDocument, "_value", this.aggregator.getResult());
                aggregateResults.add(aggregateDocument);
            }
            headers.put("x-ms-request-charge", Double.toString(requestCharge));
            FeedResponse frp = BridgeInternal.createFeedResponse(aggregateResults, headers);
            if (!this.queryMetricsMap.isEmpty()) {
                for (Map.Entry entry : this.queryMetricsMap.entrySet()) {
                    BridgeInternal.putQueryMetricsIntoMap(frp, (String)entry.getKey(), (QueryMetrics)entry.getValue());
                }
            }
            return frp;
        }).flux();
    }

    public static <T extends Resource> Flux<IDocumentQueryExecutionComponent<T>> createAsync(Function<String, Flux<IDocumentQueryExecutionComponent<T>>> createSourceComponentFunction, Collection<AggregateOperator> aggregates, String continuationToken) {
        return createSourceComponentFunction.apply(continuationToken).map(component -> new AggregateDocumentQueryExecutionContext(component, aggregates));
    }

    public IDocumentQueryExecutionComponent<T> getComponent() {
        return this.component;
    }
}

