/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.query.DistinctMap;
import com.azure.cosmos.models.Resource;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.security.NoSuchAlgorithmException;

public class OrderedDistinctMap
extends DistinctMap {
    private volatile String lastHash;

    public OrderedDistinctMap(String lastHash) {
        this.lastHash = lastHash;
    }

    @Override
    public boolean add(Resource resource, Utils.ValueHolder<String> outHash) {
        try {
            outHash.v = this.getHash(resource);
            boolean value = !StringUtils.equals(this.lastHash, (CharSequence)outHash.v);
            this.lastHash = (String)outHash.v;
            return value;
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

