/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncStoredProcedure;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.StoredProcedureResponse;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.CosmosResponse;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;

public class CosmosAsyncStoredProcedureResponse
extends CosmosResponse<CosmosStoredProcedureProperties> {
    private final CosmosAsyncStoredProcedure storedProcedure;
    private final StoredProcedureResponse storedProcedureResponse;

    CosmosAsyncStoredProcedureResponse(ResourceResponse<StoredProcedure> response, CosmosAsyncContainer cosmosContainer) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty(bodyAsString)) {
            this.storedProcedure = null;
        } else {
            super.setProperties(new CosmosStoredProcedureProperties(bodyAsString));
            this.storedProcedure = BridgeInternal.createCosmosAsyncStoredProcedure(this.getProperties().getId(), cosmosContainer);
        }
        this.storedProcedureResponse = null;
    }

    CosmosAsyncStoredProcedureResponse(StoredProcedureResponse response, CosmosAsyncContainer cosmosContainer, String storedProcedureId) {
        super(response);
        this.storedProcedureResponse = response;
        this.storedProcedure = BridgeInternal.createCosmosAsyncStoredProcedure(storedProcedureId, cosmosContainer);
    }

    @Override
    public CosmosStoredProcedureProperties getProperties() {
        return (CosmosStoredProcedureProperties)super.getProperties();
    }

    public CosmosAsyncStoredProcedure getStoredProcedure() {
        return this.storedProcedure;
    }

    @Override
    public String getActivityId() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getActivityId();
        }
        return super.getActivityId();
    }

    @Override
    public String getSessionToken() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getSessionToken();
        }
        return super.getSessionToken();
    }

    @Override
    public int getStatusCode() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getStatusCode();
        }
        return super.getStatusCode();
    }

    @Override
    public double getRequestCharge() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getRequestCharge();
        }
        return super.getRequestCharge();
    }

    public String getResponseAsString() {
        return this.storedProcedureResponse.getResponseAsString();
    }

    public String getScriptLog() {
        return this.storedProcedureResponse.getScriptLog();
    }
}

