/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.models.ConflictResolutionPolicy;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.Resource;
import com.azure.cosmos.models.UniqueKeyPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosContainerProperties
extends Resource {
    private IndexingPolicy indexingPolicy;
    private UniqueKeyPolicy uniqueKeyPolicy;
    private PartitionKeyDefinition partitionKeyDefinition;

    public CosmosContainerProperties(String id, String partitionKeyPath) {
        super.setId(id);
        PartitionKeyDefinition partitionKeyDef = new PartitionKeyDefinition();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(partitionKeyPath);
        partitionKeyDef.setPaths(paths);
        this.setPartitionKeyDefinition(partitionKeyDef);
    }

    public CosmosContainerProperties(String id, PartitionKeyDefinition partitionKeyDefinition) {
        super.setId(id);
        this.setPartitionKeyDefinition(partitionKeyDefinition);
    }

    CosmosContainerProperties(String json) {
        super(json);
    }

    CosmosContainerProperties(DocumentCollection collection) {
        super(collection.toJson());
    }

    static List<CosmosContainerProperties> getFromV2Results(List<DocumentCollection> results) {
        return results.stream().map(CosmosContainerProperties::new).collect(Collectors.toList());
    }

    public IndexingPolicy getIndexingPolicy() {
        if (this.indexingPolicy == null) {
            this.indexingPolicy = super.has("indexingPolicy") ? super.getObject("indexingPolicy", IndexingPolicy.class, new boolean[0]) : new IndexingPolicy();
        }
        return this.indexingPolicy;
    }

    public CosmosContainerProperties setIndexingPolicy(IndexingPolicy indexingPolicy) {
        if (indexingPolicy == null) {
            throw new IllegalArgumentException("IndexingPolicy cannot be null.");
        }
        this.indexingPolicy = indexingPolicy;
        super.set("indexingPolicy", indexingPolicy);
        return this;
    }

    public UniqueKeyPolicy getUniqueKeyPolicy() {
        if (this.uniqueKeyPolicy == null) {
            this.uniqueKeyPolicy = super.getObject("uniqueKeyPolicy", UniqueKeyPolicy.class, new boolean[0]);
            if (this.uniqueKeyPolicy == null) {
                this.uniqueKeyPolicy = new UniqueKeyPolicy();
            }
        }
        return this.uniqueKeyPolicy;
    }

    public CosmosContainerProperties setUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        if (uniqueKeyPolicy == null) {
            throw new IllegalArgumentException("uniqueKeyPolicy cannot be null.");
        }
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        super.set("uniqueKeyPolicy", uniqueKeyPolicy);
        return this;
    }

    public PartitionKeyDefinition getPartitionKeyDefinition() {
        if (this.partitionKeyDefinition == null) {
            this.partitionKeyDefinition = super.has("partitionKey") ? super.getObject("partitionKey", PartitionKeyDefinition.class, new boolean[0]) : new PartitionKeyDefinition();
        }
        return this.partitionKeyDefinition;
    }

    public CosmosContainerProperties setPartitionKeyDefinition(PartitionKeyDefinition partitionKeyDefinition) {
        if (partitionKeyDefinition == null) {
            throw new IllegalArgumentException("partitionKeyDefinition cannot be null.");
        }
        this.partitionKeyDefinition = partitionKeyDefinition;
        return this;
    }

    public ConflictResolutionPolicy getConflictResolutionPolicy() {
        return super.getObject("conflictResolutionPolicy", ConflictResolutionPolicy.class, new boolean[0]);
    }

    public CosmosContainerProperties setConflictResolutionPolicy(ConflictResolutionPolicy value) {
        if (value == null) {
            throw new IllegalArgumentException("CONFLICT_RESOLUTION_POLICY cannot be null.");
        }
        super.set("conflictResolutionPolicy", value);
        return this;
    }

    public Integer getDefaultTimeToLiveInSeconds() {
        if (super.has("defaultTtl")) {
            return super.getInt("defaultTtl");
        }
        return null;
    }

    public void setDefaultTimeToLiveInSeconds(Integer timeToLive) {
        if (timeToLive != null) {
            super.set("defaultTtl", timeToLive);
        } else if (super.has("defaultTtl")) {
            super.remove("defaultTtl");
        }
    }

    DocumentCollection getV2Collection() {
        DocumentCollection collection = new DocumentCollection(this.toJson());
        collection.setPartitionKey(this.getPartitionKeyDefinition());
        collection.setIndexingPolicy(this.getIndexingPolicy());
        return collection;
    }
}

