/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.models.AccessCondition;

public final class CosmosContainerRequestOptions {
    private Integer offerThroughput;
    private boolean populateQuotaInfo;
    private ConsistencyLevel consistencyLevel;
    private String sessionToken;
    private AccessCondition accessCondition;

    Integer getOfferThroughput() {
        return this.offerThroughput;
    }

    CosmosContainerRequestOptions setOfferThroughput(Integer offerThroughput) {
        this.offerThroughput = offerThroughput;
        return this;
    }

    public boolean isQuotaInfoPopulated() {
        return this.populateQuotaInfo;
    }

    public CosmosContainerRequestOptions setQuotaInfoPopulated(boolean populateQuotaInfo) {
        this.populateQuotaInfo = populateQuotaInfo;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public CosmosContainerRequestOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public CosmosContainerRequestOptions setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public AccessCondition getAccessCondition() {
        return this.accessCondition;
    }

    public CosmosContainerRequestOptions setAccessCondition(AccessCondition accessCondition) {
        this.accessCondition = accessCondition;
        return this;
    }

    RequestOptions toRequestOptions() {
        RequestOptions options = new RequestOptions();
        options.setAccessCondition(this.accessCondition);
        options.setOfferThroughput(this.offerThroughput);
        options.setPopulateQuotaInfo(this.populateQuotaInfo);
        options.setSessionToken(this.sessionToken);
        options.setConsistencyLevel(this.consistencyLevel);
        return options;
    }
}

