/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.JsonSerializable;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PermissionMode;
import com.azure.cosmos.models.Resource;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public final class CosmosPermissionProperties
extends Resource {
    static List<CosmosPermissionProperties> getFromV2Results(List<Permission> results) {
        return results.stream().map(permission -> new CosmosPermissionProperties(permission.toJson())).collect(Collectors.toList());
    }

    public CosmosPermissionProperties() {
    }

    @Override
    public CosmosPermissionProperties setId(String id) {
        super.setId(id);
        return this;
    }

    CosmosPermissionProperties(String jsonString) {
        super(jsonString);
    }

    public String getResourceLink() {
        return super.getString("resource");
    }

    public CosmosPermissionProperties setResourceLink(String resourceLink) {
        super.set("resource", resourceLink);
        return this;
    }

    public PermissionMode getPermissionMode() {
        String value = super.getString("permissionMode");
        return PermissionMode.valueOf(StringUtils.upperCase(value));
    }

    public CosmosPermissionProperties setPermissionMode(PermissionMode permissionMode) {
        this.set("permissionMode", permissionMode.toString().toLowerCase(Locale.ROOT));
        return this;
    }

    public PartitionKey getResourcePartitionKey() {
        PartitionKey key = null;
        Object value = super.get("resourcePartitionKey");
        if (value != null) {
            ArrayNode arrayValue = (ArrayNode)value;
            key = new PartitionKey(JsonSerializable.getValue(arrayValue.get(0)));
        }
        return key;
    }

    public CosmosPermissionProperties setResourcePartitionKey(PartitionKey partitionKey) {
        super.set("resourcePartitionKey", BridgeInternal.getPartitionKeyInternal(partitionKey).toJson());
        return this;
    }

    Permission getV2Permissions() {
        return new Permission(this.toJson());
    }
}

