/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import java.util.HashMap;
import java.util.Map;

public enum CosmosResourceType {
    SYSTEM(-100, "System"),
    ATTACHMENT(3, "Attachment"),
    DOCUMENT_COLLECTION(1, "DocumentCollection"),
    CONFLICT(107, "Conflict"),
    DATABASE(0, "Database"),
    DOCUMENT(2, "Document"),
    INDEX(104, "Index"),
    OFFER(113, "Offer"),
    PERMISSION(5, "Permission"),
    STORED_PROCEDURE(109, "StoredProcedure"),
    TRIGGER(110, "Trigger"),
    USER(4, "User"),
    USER_DEFINED_FUNCTION(111, "UserDefinedFunction");

    private final int value;
    private final String overWireValue;
    private static Map<String, CosmosResourceType> cosmosResourceTypeMap;

    static CosmosResourceType fromServiceSerializedFormat(String cosmosResourceType) {
        return cosmosResourceTypeMap.get(cosmosResourceType);
    }

    private CosmosResourceType(int value, String overWireValue) {
        this.value = value;
        this.overWireValue = overWireValue;
    }

    public String toString() {
        return this.overWireValue;
    }

    static {
        cosmosResourceTypeMap = new HashMap<String, CosmosResourceType>();
        for (CosmosResourceType crt : CosmosResourceType.values()) {
            cosmosResourceTypeMap.put(crt.toString(), crt);
        }
    }
}

