/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosResponseDiagnostics;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.StoredProcedureResponse;
import com.azure.cosmos.models.Resource;
import java.time.Duration;
import java.util.Map;

public class CosmosResponse<T extends Resource> {
    private T properties;
    protected final ResourceResponse<?> resourceResponseWrapper;

    protected CosmosResponse(ResourceResponse<?> resourceResponse) {
        this.resourceResponseWrapper = resourceResponse;
    }

    protected CosmosResponse(T properties) {
        this.properties = properties;
        this.resourceResponseWrapper = null;
    }

    protected CosmosResponse(ResourceResponse<?> resourceResponse, T properties) {
        this.resourceResponseWrapper = resourceResponse;
        this.properties = properties;
    }

    protected CosmosResponse(StoredProcedureResponse response) {
        this.resourceResponseWrapper = null;
    }

    public T getProperties() {
        return this.properties;
    }

    protected CosmosResponse<T> setProperties(T resourceSettings) {
        this.properties = resourceSettings;
        return this;
    }

    public String getMaxResourceQuota() {
        return this.resourceResponseWrapper.getMaxResourceQuota();
    }

    public String getCurrentResourceQuotaUsage() {
        return this.resourceResponseWrapper.getCurrentResourceQuotaUsage();
    }

    public String getActivityId() {
        return this.resourceResponseWrapper.getActivityId();
    }

    public double getRequestCharge() {
        return this.resourceResponseWrapper.getRequestCharge();
    }

    public int getStatusCode() {
        return this.resourceResponseWrapper.getStatusCode();
    }

    public String getSessionToken() {
        return this.resourceResponseWrapper.getSessionToken();
    }

    public Map<String, String> getResponseHeaders() {
        return this.resourceResponseWrapper.getResponseHeaders();
    }

    public CosmosResponseDiagnostics getResponseDiagnostics() {
        return this.resourceResponseWrapper.getResponseDiagnostics();
    }

    public Duration getRequestLatency() {
        return this.resourceResponseWrapper.getRequestLatency();
    }
}

