/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.IndexKind;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.DataType;
import com.azure.cosmos.models.HashIndex;
import com.azure.cosmos.models.JsonSerializable;
import com.azure.cosmos.models.RangeIndex;
import com.azure.cosmos.models.SpatialIndex;

public abstract class Index
extends JsonSerializable {
    Index(IndexKind indexKind) {
        this.setKind(indexKind);
    }

    Index(String jsonString, IndexKind indexKind) {
        super(jsonString);
        this.setKind(indexKind);
    }

    public static RangeIndex range(DataType dataType) {
        return new RangeIndex(dataType);
    }

    public static RangeIndex range(DataType dataType, int precision) {
        return new RangeIndex(dataType, precision);
    }

    public static HashIndex hash(DataType dataType) {
        return new HashIndex(dataType);
    }

    public static HashIndex hash(DataType dataType, int precision) {
        return new HashIndex(dataType, precision);
    }

    public static SpatialIndex spatial(DataType dataType) {
        return new SpatialIndex(dataType);
    }

    IndexKind getKind() {
        IndexKind result = null;
        try {
            result = IndexKind.valueOf(StringUtils.upperCase(super.getString("kind")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID index kind value %s.", (Object)super.getString("kind"));
        }
        return result;
    }

    private Index setKind(IndexKind indexKind) {
        super.set("kind", indexKind.toString());
        return this;
    }

    @Override
    protected void populatePropertyBag() {
        super.populatePropertyBag();
    }
}

