/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.models.JsonSerializable;
import com.azure.cosmos.models.SqlParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class SqlQuerySpec
extends JsonSerializable {
    private List<SqlParameter> parameters;

    public SqlQuerySpec() {
    }

    public SqlQuerySpec(String queryText) {
        this.setQueryText(queryText);
    }

    public SqlQuerySpec(String queryText, List<SqlParameter> parameters) {
        this.setQueryText(queryText);
        this.parameters = parameters;
    }

    public SqlQuerySpec(String queryText, SqlParameter ... parameters) {
        this.setQueryText(queryText);
        this.parameters = Arrays.asList(parameters);
    }

    public String getQueryText() {
        return super.getString("query");
    }

    public SqlQuerySpec setQueryText(String queryText) {
        super.set("query", queryText);
        return this;
    }

    public List<SqlParameter> getParameters() {
        if (this.parameters == null) {
            Collection<SqlParameter> sqlParameters = super.getCollection("parameters", SqlParameter.class, new boolean[0]);
            if (sqlParameters == null) {
                sqlParameters = new ArrayList<SqlParameter>();
            }
            this.parameters = new ArrayList<SqlParameter>(sqlParameters);
        }
        return this.parameters;
    }

    public SqlQuerySpec setParameters(List<SqlParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    protected void populatePropertyBag() {
        boolean defaultParameters;
        super.populatePropertyBag();
        boolean bl = defaultParameters = this.parameters != null && this.parameters.size() != 0;
        if (defaultParameters) {
            super.set("parameters", this.parameters);
        } else {
            super.remove("parameters");
        }
    }
}

