/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncConflict;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncScripts;
import com.azure.cosmos.implementation.CosmosItemProperties;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.CosmosAsyncContainerResponse;
import com.azure.cosmos.models.CosmosAsyncItemResponse;
import com.azure.cosmos.models.CosmosConflictProperties;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.FeedOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class CosmosAsyncContainer {
    private final CosmosAsyncDatabase database;
    private final String id;
    private final String link;
    private CosmosAsyncScripts scripts;

    CosmosAsyncContainer(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
        this.link = this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
    }

    public String getId() {
        return this.id;
    }

    public Mono<CosmosAsyncContainerResponse> read() {
        return this.read(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosAsyncContainerResponse> read(CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().readCollection(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncContainerResponse(response, this.database)).single();
    }

    public Mono<CosmosAsyncContainerResponse> delete(CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().deleteCollection(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncContainerResponse(response, this.database)).single();
    }

    public Mono<CosmosAsyncContainerResponse> delete() {
        return this.delete(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosAsyncContainerResponse> replace(CosmosContainerProperties containerProperties) {
        return this.replace(containerProperties, null);
    }

    public Mono<CosmosAsyncContainerResponse> replace(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().replaceCollection(ModelBridgeInternal.getV2Collection(containerProperties), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncContainerResponse(response, this.database)).single();
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> createItem(T item) {
        return this.createItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        return this.createItem(item, options);
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> createItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        Class<?> itemType = item.getClass();
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.database.getDocClientWrapper().createDocument(this.getLink(), item, requestOptions, true).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType)).single();
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> upsertItem(T item) {
        return this.upsertItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> upsertItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        Class<?> itemType = item.getClass();
        return this.getDatabase().getDocClientWrapper().upsertDocument(this.getLink(), item, ModelBridgeInternal.toRequestOptions(options), true).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType)).single();
    }

    public <T> CosmosPagedFlux<T> readAllItems(Class<T> classType) {
        return this.readAllItems(new FeedOptions(), classType);
    }

    public <T> CosmosPagedFlux<T> readAllItems(FeedOptions options, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDatabase().getDocClientWrapper().readDocuments(this.getLink(), options).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, classType));
        });
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, Class<T> classType) {
        return this.queryItems(new SqlQuerySpec(query), classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, FeedOptions options, Class<T> classType) {
        return this.queryItems(new SqlQuerySpec(query), options, classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, Class<T> classType) {
        return this.queryItems(querySpec, new FeedOptions(), classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, FeedOptions options, Class<T> classType) {
        return this.queryItemsInternal(querySpec, options, classType);
    }

    private <T> CosmosPagedFlux<T> queryItemsInternal(SqlQuerySpec sqlQuerySpec, FeedOptions feedOptions, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, feedOptions);
            return this.getDatabase().getDocClientWrapper().queryDocuments(this.getLink(), sqlQuerySpec, feedOptions).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, classType));
        });
    }

    private <T> FeedResponse<T> prepareFeedResponse(FeedResponse<Document> response, Class<T> classType) {
        return BridgeInternal.createFeedResponseWithQueryMetrics(response.getResults().stream().map(document -> ModelBridgeInternal.toObjectFromJsonSerializable(document, classType)).collect(Collectors.toList()), response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response));
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, Class<T> itemType) {
        return this.readItem(itemId, partitionKey, ModelBridgeInternal.createCosmosItemRequestOptions(partitionKey), itemType);
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options, Class<T> itemType) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.getDatabase().getDocClientWrapper().readDocument(this.getItemLink(itemId), requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType)).single();
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey) {
        return this.replaceItem(item, itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        Document doc = CosmosItemProperties.fromObject(item);
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        Class<?> itemType = item.getClass();
        return this.getDatabase().getDocClientWrapper().replaceDocument(this.getItemLink(itemId), doc, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType)).single();
    }

    public Mono<CosmosAsyncItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey) {
        return this.deleteItem(itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public Mono<CosmosAsyncItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.getDatabase().getDocClientWrapper().deleteDocument(this.getItemLink(itemId), requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponseWithObjectType(response)).single();
    }

    private String getItemLink(String itemId) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLink());
        builder.append("/");
        builder.append("docs");
        builder.append("/");
        builder.append(itemId);
        return builder.toString();
    }

    public CosmosAsyncScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosAsyncScripts(this);
        }
        return this.scripts;
    }

    public CosmosPagedFlux<CosmosConflictProperties> readAllConflicts(FeedOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().readConflicts(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosConflictPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosConflictProperties> queryConflicts(String query) {
        return this.queryConflicts(query, new FeedOptions());
    }

    public CosmosPagedFlux<CosmosConflictProperties> queryConflicts(String query, FeedOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().queryConflicts(this.getLink(), query, options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosConflictPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosAsyncConflict getConflict(String id) {
        return new CosmosAsyncConflict(id, this);
    }

    public Mono<Integer> readProvisionedThroughput() {
        return this.read().flatMap(cosmosContainerResponse -> this.database.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + cosmosContainerResponse.getProperties().getResourceId() + "'", new FeedOptions()).single()).flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosClientException(400, "No offers found for the resource")));
            }
            return this.database.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(cosmosOfferResponse -> ((Offer)cosmosOfferResponse.getResource()).getThroughput());
    }

    public Mono<Integer> replaceProvisionedThroughput(int requestUnitsPerSecond) {
        return this.read().flatMap(cosmosContainerResponse -> this.database.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + cosmosContainerResponse.getProperties().getResourceId() + "'", new FeedOptions()).single()).flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosClientException(400, "No offers found for the resource")));
            }
            Offer offer = (Offer)offerFeedResponse.getResults().get(0);
            offer.setThroughput(requestUnitsPerSecond);
            return this.database.getDocClientWrapper().replaceOffer(offer).single();
        }).map(offerResourceResponse -> ((Offer)offerResourceResponse.getResource()).getThroughput());
    }

    public Mono<ThroughputResponse> replaceThroughput(ThroughputProperties throughputProperties) {
        return this.read().flatMap(response -> this.database.getDocClientWrapper().queryOffers(this.database.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), new FeedOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosClientException(400, "No offers found for the resource " + this.getId())));
            }
            Offer existingOffer = (Offer)offerFeedResponse.getResults().get(0);
            Offer updatedOffer = ModelBridgeInternal.updateOfferFromProperties(existingOffer, throughputProperties);
            return this.database.getDocClientWrapper().replaceOffer(updatedOffer).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    public Mono<ThroughputResponse> readThroughput() {
        return this.read().flatMap(response -> this.database.getDocClientWrapper().queryOffers(this.database.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), new FeedOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosClientException(400, "No offers found for the resource " + this.getId())));
            }
            return this.database.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    public CosmosAsyncDatabase getDatabase() {
        return this.database;
    }

    String getURIPathSegment() {
        return "colls";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        return this.link;
    }
}

