/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.CosmosAsyncContainerResponse;
import com.azure.cosmos.models.CosmosAsyncDatabaseResponse;
import com.azure.cosmos.models.CosmosAsyncUserResponse;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosUserProperties;
import com.azure.cosmos.models.FeedOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import java.util.Collections;
import java.util.List;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosAsyncDatabase {
    private final CosmosAsyncClient client;
    private final String id;
    private final String link;

    CosmosAsyncDatabase(String id, CosmosAsyncClient client) {
        this.id = id;
        this.client = client;
        this.link = this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
    }

    public String getId() {
        return this.id;
    }

    public Mono<CosmosAsyncDatabaseResponse> read() {
        return this.read(new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosAsyncDatabaseResponse> read(CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        return this.getDocClientWrapper().readDatabase(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncDatabaseResponse(response, this.getClient())).single();
    }

    public Mono<CosmosAsyncDatabaseResponse> delete() {
        return this.delete(new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosAsyncDatabaseResponse> delete(CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        return this.getDocClientWrapper().deleteDatabase(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncDatabaseResponse(response, this.getClient())).single();
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(CosmosContainerProperties containerProperties) {
        return this.createContainer(containerProperties, new CosmosContainerRequestOptions());
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(CosmosContainerProperties containerProperties, int throughput) {
        if (containerProperties == null) {
            throw new IllegalArgumentException("containerProperties");
        }
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        ModelBridgeInternal.setOfferThroughput(options, (Integer)throughput);
        return this.createContainer(containerProperties, options);
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(CosmosContainerProperties containerProperties, ThroughputProperties throughputProperties, CosmosContainerRequestOptions options) {
        ModelBridgeInternal.setOfferProperties(options, throughputProperties);
        return this.createContainer(containerProperties, options);
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        if (containerProperties == null) {
            throw new IllegalArgumentException("containerProperties");
        }
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.getDocClientWrapper().createCollection(this.getLink(), ModelBridgeInternal.getV2Collection(containerProperties), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncContainerResponse(response, this)).single();
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(CosmosContainerProperties containerProperties, int throughput, CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        ModelBridgeInternal.setOfferThroughput(options, (Integer)throughput);
        return this.createContainer(containerProperties, options);
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(String id, String partitionKeyPath) {
        return this.createContainer(new CosmosContainerProperties(id, partitionKeyPath));
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(String id, String partitionKeyPath, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        ModelBridgeInternal.setOfferThroughput(options, (Integer)throughput);
        return this.createContainer(new CosmosContainerProperties(id, partitionKeyPath), options);
    }

    public Mono<CosmosAsyncContainerResponse> createContainerIfNotExists(CosmosContainerProperties containerProperties) {
        CosmosAsyncContainer container = this.getContainer(containerProperties.getId());
        return this.createContainerIfNotExistsInternal(containerProperties, container, null);
    }

    public Mono<CosmosAsyncContainerResponse> createContainerIfNotExists(CosmosContainerProperties containerProperties, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        ModelBridgeInternal.setOfferThroughput(options, (Integer)throughput);
        CosmosAsyncContainer container = this.getContainer(containerProperties.getId());
        return this.createContainerIfNotExistsInternal(containerProperties, container, options);
    }

    public Mono<CosmosAsyncContainerResponse> createContainerIfNotExists(String id, String partitionKeyPath) {
        CosmosAsyncContainer container = this.getContainer(id);
        return this.createContainerIfNotExistsInternal(new CosmosContainerProperties(id, partitionKeyPath), container, null);
    }

    public Mono<CosmosAsyncContainerResponse> createContainerIfNotExists(String id, String partitionKeyPath, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        ModelBridgeInternal.setOfferThroughput(options, (Integer)throughput);
        CosmosAsyncContainer container = this.getContainer(id);
        return this.createContainerIfNotExistsInternal(new CosmosContainerProperties(id, partitionKeyPath), container, options);
    }

    private Mono<CosmosAsyncContainerResponse> createContainerIfNotExistsInternal(CosmosContainerProperties containerProperties, CosmosAsyncContainer container, CosmosContainerRequestOptions options) {
        return container.read(options).onErrorResume(exception -> {
            CosmosClientException cosmosClientException;
            Throwable unwrappedException = Exceptions.unwrap((Throwable)exception);
            if (unwrappedException instanceof CosmosClientException && (cosmosClientException = (CosmosClientException)((Object)((Object)unwrappedException))).getStatusCode() == 404) {
                return this.createContainer(containerProperties, options);
            }
            return Mono.error((Throwable)unwrappedException);
        });
    }

    public CosmosPagedFlux<CosmosContainerProperties> readAllContainers(FeedOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDocClientWrapper().readCollections(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosContainerPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosContainerProperties> readAllContainers() {
        return this.readAllContainers(new FeedOptions());
    }

    public CosmosPagedFlux<CosmosContainerProperties> queryContainers(String query) {
        return this.queryContainers(new SqlQuerySpec(query));
    }

    public CosmosPagedFlux<CosmosContainerProperties> queryContainers(String query, FeedOptions options) {
        return this.queryContainers(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosContainerProperties> queryContainers(SqlQuerySpec querySpec) {
        return this.queryContainers(querySpec, new FeedOptions());
    }

    public CosmosPagedFlux<CosmosContainerProperties> queryContainers(SqlQuerySpec querySpec, FeedOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDocClientWrapper().queryCollections(this.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosContainerPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosAsyncContainer getContainer(String id) {
        return new CosmosAsyncContainer(id, this);
    }

    public Mono<CosmosAsyncUserResponse> createUser(CosmosUserProperties userProperties) {
        return this.getDocClientWrapper().createUser(this.getLink(), ModelBridgeInternal.getV2User(userProperties), null).map(response -> ModelBridgeInternal.createCosmosAsyncUserResponse(response, this)).single();
    }

    public Mono<CosmosAsyncUserResponse> upsertUser(CosmosUserProperties userProperties) {
        return this.getDocClientWrapper().upsertUser(this.getLink(), ModelBridgeInternal.getV2User(userProperties), null).map(response -> ModelBridgeInternal.createCosmosAsyncUserResponse(response, this)).single();
    }

    public CosmosPagedFlux<CosmosUserProperties> readAllUsers() {
        return this.readAllUsers(new FeedOptions());
    }

    public CosmosPagedFlux<CosmosUserProperties> readAllUsers(FeedOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDocClientWrapper().readUsers(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosUserPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosUserProperties> queryUsers(String query) {
        return this.queryUsers(query, new FeedOptions());
    }

    public CosmosPagedFlux<CosmosUserProperties> queryUsers(String query, FeedOptions options) {
        return this.queryUsers(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosUserProperties> queryUsers(SqlQuerySpec querySpec) {
        return this.queryUsers(querySpec, new FeedOptions());
    }

    public CosmosPagedFlux<CosmosUserProperties> queryUsers(SqlQuerySpec querySpec, FeedOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDocClientWrapper().queryUsers(this.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponseWithQueryMetrics(ModelBridgeInternal.getCosmosUserPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response)));
        });
    }

    public CosmosAsyncUser getUser(String id) {
        return new CosmosAsyncUser(id, this);
    }

    public Mono<Integer> readProvisionedThroughput() {
        return this.read().flatMap(cosmosDatabaseResponse -> this.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + cosmosDatabaseResponse.getProperties().getResourceId() + "'", new FeedOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosClientException(400, "No offers found for the resource")));
            }
            return this.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(cosmosContainerResponse1 -> ((Offer)cosmosContainerResponse1.getResource()).getThroughput()));
    }

    public Mono<Integer> replaceProvisionedThroughput(int requestUnitsPerSecond) {
        return this.read().flatMap(cosmosDatabaseResponse -> this.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + cosmosDatabaseResponse.getProperties().getResourceId() + "'", new FeedOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosClientException(400, "No offers found for the resource")));
            }
            Offer offer = (Offer)offerFeedResponse.getResults().get(0);
            offer.setThroughput(requestUnitsPerSecond);
            return this.getDocClientWrapper().replaceOffer(offer).single();
        }).map(offerResourceResponse -> ((Offer)offerResourceResponse.getResource()).getThroughput()));
    }

    public Mono<ThroughputResponse> replaceThroughput(ThroughputProperties throughputProperties) {
        return this.read().flatMap(response -> this.getDocClientWrapper().queryOffers(this.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), new FeedOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosClientException(400, "No offers found for the resource " + this.getId())));
            }
            Offer existingOffer = (Offer)offerFeedResponse.getResults().get(0);
            Offer updatedOffer = ModelBridgeInternal.updateOfferFromProperties(existingOffer, throughputProperties);
            return this.getDocClientWrapper().replaceOffer(updatedOffer).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    public Mono<ThroughputResponse> readThroughput() {
        return this.read().flatMap(response -> this.getDocClientWrapper().queryOffers(this.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), new FeedOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosClientException(400, "No offers found for the resource " + this.getId())));
            }
            return this.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    SqlQuerySpec getOfferQuerySpecFromResourceId(String resourceId) {
        String queryText = "select * from c where c.offerResourceId = @resourceId";
        SqlQuerySpec querySpec = new SqlQuerySpec(queryText);
        List<SqlParameter> parameters = Collections.singletonList(new SqlParameter("@resourceId", resourceId));
        querySpec.setParameters(parameters);
        return querySpec;
    }

    CosmosAsyncClient getClient() {
        return this.client;
    }

    AsyncDocumentClient getDocClientWrapper() {
        return this.client.getDocClientWrapper();
    }

    String getURIPathSegment() {
        return "dbs";
    }

    String getParentLink() {
        return "";
    }

    String getLink() {
        return this.link;
    }
}

