/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.models.CosmosAsyncStoredProcedureResponse;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import com.azure.cosmos.models.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncStoredProcedure {
    private final CosmosAsyncContainer cosmosContainer;
    private String id;

    CosmosAsyncStoredProcedure(String id, CosmosAsyncContainer cosmosContainer) {
        this.id = id;
        this.cosmosContainer = cosmosContainer;
    }

    public String id() {
        return this.id;
    }

    CosmosAsyncStoredProcedure id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncStoredProcedureResponse> read() {
        return this.read(null);
    }

    public Mono<CosmosAsyncStoredProcedureResponse> read(CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().readStoredProcedure(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncStoredProcedureResponse(response, this.cosmosContainer)).single();
    }

    public Mono<CosmosAsyncStoredProcedureResponse> delete() {
        return this.delete(null);
    }

    public Mono<CosmosAsyncStoredProcedureResponse> delete(CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().deleteStoredProcedure(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncStoredProcedureResponse(response, this.cosmosContainer)).single();
    }

    public Mono<CosmosAsyncStoredProcedureResponse> execute(Object[] procedureParams, CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().executeStoredProcedure(this.getLink(), ModelBridgeInternal.toRequestOptions(options), procedureParams).map(response -> ModelBridgeInternal.createCosmosAsyncStoredProcedureResponse(response, this.cosmosContainer, this.id)).single();
    }

    public Mono<CosmosAsyncStoredProcedureResponse> replace(CosmosStoredProcedureProperties storedProcedureSettings) {
        return this.replace(storedProcedureSettings, null);
    }

    public Mono<CosmosAsyncStoredProcedureResponse> replace(CosmosStoredProcedureProperties storedProcedureSettings, CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().replaceStoredProcedure(new StoredProcedure(ModelBridgeInternal.toJsonFromJsonSerializable(ModelBridgeInternal.getResource(storedProcedureSettings))), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncStoredProcedureResponse(response, this.cosmosContainer)).single();
    }

    String getURIPathSegment() {
        return "sprocs";
    }

    String getParentLink() {
        return this.cosmosContainer.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

