/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.models.CosmosAsyncDatabaseResponse;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.FeedOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.CosmosPagedIterable;
import com.azure.cosmos.util.UtilBridgeInternal;
import java.io.Closeable;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public final class CosmosClient
implements Closeable {
    private final CosmosAsyncClient asyncClientWrapper;

    CosmosClient(CosmosClientBuilder builder) {
        this.asyncClientWrapper = builder.buildAsyncClient();
    }

    public CosmosDatabaseResponse createDatabaseIfNotExists(CosmosDatabaseProperties databaseProperties) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabaseIfNotExists(databaseProperties));
    }

    public CosmosDatabaseResponse createDatabaseIfNotExists(String id) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabaseIfNotExists(id));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties, options));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties));
    }

    public CosmosDatabaseResponse createDatabase(String id) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(id));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, int throughput, CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties, throughput, options));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, int throughput) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties, throughput));
    }

    public CosmosDatabaseResponse createDatabase(String id, int throughput) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(id, throughput));
    }

    CosmosDatabaseResponse mapDatabaseResponseAndBlock(Mono<CosmosAsyncDatabaseResponse> databaseMono) throws CosmosClientException {
        try {
            return (CosmosDatabaseResponse)databaseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)((Object)throwable);
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    public CosmosPagedIterable<CosmosDatabaseProperties> readAllDatabases(FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncClientWrapper.readAllDatabases(options));
    }

    public CosmosPagedIterable<CosmosDatabaseProperties> readAllDatabases() {
        return this.getCosmosPagedIterable(this.asyncClientWrapper.readAllDatabases());
    }

    public CosmosPagedIterable<CosmosDatabaseProperties> queryDatabases(String query, FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncClientWrapper.queryDatabases(query, options));
    }

    public CosmosPagedIterable<CosmosDatabaseProperties> queryDatabases(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncClientWrapper.queryDatabases(querySpec, options));
    }

    public CosmosDatabase getDatabase(String id) {
        return new CosmosDatabase(id, this, this.asyncClientWrapper.getDatabase(id));
    }

    CosmosDatabaseResponse convertResponse(CosmosAsyncDatabaseResponse response) {
        return ModelBridgeInternal.createCosmosDatabaseResponse(response, this);
    }

    CosmosAsyncClient asyncClient() {
        return this.asyncClientWrapper;
    }

    @Override
    public void close() {
        this.asyncClientWrapper.close();
    }

    private <T> CosmosPagedIterable<T> getCosmosPagedIterable(CosmosPagedFlux<T> cosmosPagedFlux) {
        return UtilBridgeInternal.createCosmosPagedIterable(cosmosPagedFlux);
    }
}

