/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncTrigger;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.models.CosmosTriggerProperties;
import com.azure.cosmos.models.CosmosTriggerResponse;

public class CosmosTrigger {
    private final String id;
    private final CosmosContainer container;
    private final CosmosAsyncTrigger trigger;

    CosmosTrigger(String id, CosmosContainer container, CosmosAsyncTrigger trigger) {
        this.id = id;
        this.container = container;
        this.trigger = trigger;
    }

    public String getId() {
        return this.id;
    }

    public CosmosTriggerResponse read() throws CosmosClientException {
        return this.container.getScripts().mapTriggerResponseAndBlock(this.trigger.read());
    }

    public CosmosTriggerResponse replace(CosmosTriggerProperties triggerSettings) throws CosmosClientException {
        return this.container.getScripts().mapTriggerResponseAndBlock(this.trigger.replace(triggerSettings));
    }

    public CosmosTriggerResponse delete() throws CosmosClientException {
        return this.container.getScripts().mapTriggerResponseAndBlock(this.trigger.delete());
    }
}

