/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncUserDefinedFunction;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.models.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.models.CosmosUserDefinedFunctionResponse;

public class CosmosUserDefinedFunction {
    private final String id;
    private final CosmosContainer container;
    private final CosmosAsyncUserDefinedFunction userDefinedFunction;

    CosmosUserDefinedFunction(String id, CosmosContainer container, CosmosAsyncUserDefinedFunction userDefinedFunction) {
        this.id = id;
        this.container = container;
        this.userDefinedFunction = userDefinedFunction;
    }

    public String getId() {
        return this.id;
    }

    public CosmosUserDefinedFunctionResponse read() throws CosmosClientException {
        return this.container.getScripts().mapUDFResponseAndBlock(this.userDefinedFunction.read());
    }

    public CosmosUserDefinedFunctionResponse replace(CosmosUserDefinedFunctionProperties udfSettings) throws CosmosClientException {
        return this.container.getScripts().mapUDFResponseAndBlock(this.userDefinedFunction.replace(udfSettings));
    }

    public CosmosUserDefinedFunctionResponse delete() throws CosmosClientException {
        return this.container.getScripts().mapUDFResponseAndBlock(this.userDefinedFunction.delete());
    }
}

