/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import java.time.Duration;

public final class DirectConnectionConfig {
    private static final Duration DEFAULT_IDLE_ENDPOINT_TIMEOUT = Duration.ofSeconds(70L);
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ENDPOINT = 30;
    private static final int DEFAULT_MAX_REQUESTS_PER_CONNECTION = 10;
    private Duration connectionTimeout;
    private Duration idleConnectionTimeout = Duration.ZERO;
    private Duration idleEndpointTimeout;
    private int maxConnectionsPerEndpoint = 30;
    private int maxRequestsPerConnection = 10;

    public DirectConnectionConfig() {
        this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
        this.idleEndpointTimeout = DEFAULT_IDLE_ENDPOINT_TIMEOUT;
    }

    public static DirectConnectionConfig getDefaultConfig() {
        return new DirectConnectionConfig();
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public DirectConnectionConfig setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Duration getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public DirectConnectionConfig setIdleConnectionTimeout(Duration idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public Duration getIdleEndpointTimeout() {
        return this.idleEndpointTimeout;
    }

    public DirectConnectionConfig setIdleEndpointTimeout(Duration idleEndpointTimeout) {
        this.idleEndpointTimeout = idleEndpointTimeout;
        return this;
    }

    public int getMaxConnectionsPerEndpoint() {
        return this.maxConnectionsPerEndpoint;
    }

    public DirectConnectionConfig setMaxConnectionsPerEndpoint(int maxConnectionsPerEndpoint) {
        this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
        return this;
    }

    public int getMaxRequestsPerConnection() {
        return this.maxRequestsPerConnection;
    }

    public DirectConnectionConfig setMaxRequestsPerConnection(int maxRequestsPerConnection) {
        this.maxRequestsPerConnection = maxRequestsPerConnection;
        return this;
    }

    public String toString() {
        return "DirectConnectionConfig{connectionTimeout=" + this.connectionTimeout + ", idleConnectionTimeout=" + this.idleConnectionTimeout + ", idleEndpointTimeout=" + this.idleEndpointTimeout + ", maxConnectionsPerEndpoint=" + this.maxConnectionsPerEndpoint + ", maxRequestsPerConnection=" + this.maxRequestsPerConnection + '}';
    }
}

