/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import java.net.InetSocketAddress;
import java.time.Duration;

public final class GatewayConnectionConfig {
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_IDLE_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final int DEFAULT_MAX_POOL_SIZE = 1000;
    private Duration requestTimeout;
    private int maxConnectionPoolSize = 1000;
    private Duration idleConnectionTimeout = DEFAULT_IDLE_CONNECTION_TIMEOUT;
    private InetSocketAddress inetSocketProxyAddress;

    public GatewayConnectionConfig() {
        this.requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    }

    public static GatewayConnectionConfig getDefaultConfig() {
        return new GatewayConnectionConfig();
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public GatewayConnectionConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public GatewayConnectionConfig setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
        return this;
    }

    public Duration getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public GatewayConnectionConfig setIdleConnectionTimeout(Duration idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public InetSocketAddress getProxy() {
        return this.inetSocketProxyAddress;
    }

    public GatewayConnectionConfig setProxy(InetSocketAddress proxy) {
        this.inetSocketProxyAddress = proxy;
        return this;
    }

    public String toString() {
        return "GatewayConnectionConfig{requestTimeout=" + this.requestTimeout + ", maxConnectionPoolSize=" + this.maxConnectionPoolSize + ", idleConnectionTimeout=" + this.idleConnectionTimeout + ", inetSocketProxyAddress=" + this.inetSocketProxyAddress + '}';
    }
}

