/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.GatewayConnectionConfig;
import com.azure.cosmos.ThrottlingRetryOptions;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public final class ConnectionPolicy {
    public static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    public static final Duration DEFAULT_IDLE_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    public static final int DEFAULT_MAX_POOL_SIZE = 1000;
    private static final ConnectionPolicy defaultPolicy = new ConnectionPolicy(DirectConnectionConfig.getDefaultConfig());
    private ConnectionMode connectionMode;
    private String userAgentSuffix;
    private ThrottlingRetryOptions throttlingRetryOptions;
    private boolean endpointDiscoveryEnabled;
    private List<String> preferredRegions;
    private boolean multipleWriteRegionsEnabled;
    private boolean readRequestsFallbackEnabled;
    private int maxConnectionPoolSize = 1000;
    private Duration requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    private Duration idleConnectionTimeout = DEFAULT_IDLE_CONNECTION_TIMEOUT;
    private InetSocketAddress inetSocketProxyAddress;
    private Duration connectionTimeout;
    private Duration idleChannelTimeout;
    private Duration idleEndpointTimeout;
    private int maxChannelsPerEndpoint;
    private int maxRequestsPerChannel;

    public ConnectionPolicy(GatewayConnectionConfig gatewayConnectionConfig) {
        this(ConnectionMode.GATEWAY);
        this.idleConnectionTimeout = gatewayConnectionConfig.getIdleConnectionTimeout();
        this.maxConnectionPoolSize = gatewayConnectionConfig.getMaxConnectionPoolSize();
        this.requestTimeout = gatewayConnectionConfig.getRequestTimeout();
        this.inetSocketProxyAddress = gatewayConnectionConfig.getProxy();
    }

    public ConnectionPolicy(DirectConnectionConfig directConnectionConfig) {
        this(ConnectionMode.DIRECT);
        this.connectionTimeout = directConnectionConfig.getConnectionTimeout();
        this.idleChannelTimeout = directConnectionConfig.getIdleConnectionTimeout();
        this.idleEndpointTimeout = directConnectionConfig.getIdleEndpointTimeout();
        this.maxChannelsPerEndpoint = directConnectionConfig.getMaxConnectionsPerEndpoint();
        this.maxRequestsPerChannel = directConnectionConfig.getMaxRequestsPerConnection();
    }

    private ConnectionPolicy(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        this.throttlingRetryOptions = new ThrottlingRetryOptions();
        this.userAgentSuffix = "";
        this.readRequestsFallbackEnabled = true;
        this.endpointDiscoveryEnabled = true;
        this.multipleWriteRegionsEnabled = true;
    }

    public static ConnectionPolicy getDefaultPolicy() {
        return defaultPolicy;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public ConnectionPolicy setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public ConnectionPolicy setConnectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public ConnectionPolicy setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
        return this;
    }

    public Duration getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public ConnectionPolicy setIdleConnectionTimeout(Duration idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public ConnectionPolicy setUserAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
        return this;
    }

    public ThrottlingRetryOptions getThrottlingRetryOptions() {
        return this.throttlingRetryOptions;
    }

    public ConnectionPolicy setThrottlingRetryOptions(ThrottlingRetryOptions throttlingRetryOptions) {
        if (throttlingRetryOptions == null) {
            throw new IllegalArgumentException("retryOptions value must not be null.");
        }
        this.throttlingRetryOptions = throttlingRetryOptions;
        return this;
    }

    public boolean isEndpointDiscoveryEnabled() {
        return this.endpointDiscoveryEnabled;
    }

    public ConnectionPolicy setEndpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    public boolean isMultipleWriteRegionsEnabled() {
        return this.multipleWriteRegionsEnabled;
    }

    public boolean isReadRequestsFallbackEnabled() {
        return this.readRequestsFallbackEnabled;
    }

    public ConnectionPolicy setMultipleWriteRegionsEnabled(boolean multipleWriteRegionsEnabled) {
        this.multipleWriteRegionsEnabled = multipleWriteRegionsEnabled;
        return this;
    }

    public ConnectionPolicy setReadRequestsFallbackEnabled(boolean readRequestsFallbackEnabled) {
        this.readRequestsFallbackEnabled = readRequestsFallbackEnabled;
        return this;
    }

    public List<String> getPreferredRegions() {
        return this.preferredRegions != null ? this.preferredRegions : Collections.emptyList();
    }

    public ConnectionPolicy setPreferredRegions(List<String> preferredRegions) {
        this.preferredRegions = preferredRegions;
        return this;
    }

    public InetSocketAddress getProxy() {
        return this.inetSocketProxyAddress;
    }

    public ConnectionPolicy setProxy(InetSocketAddress proxy) {
        this.inetSocketProxyAddress = proxy;
        return this;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ConnectionPolicy setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Duration getIdleChannelTimeout() {
        return this.idleChannelTimeout;
    }

    public ConnectionPolicy setIdleChannelTimeout(Duration idleChannelTimeout) {
        this.idleChannelTimeout = idleChannelTimeout;
        return this;
    }

    public Duration getIdleEndpointTimeout() {
        return this.idleEndpointTimeout;
    }

    public ConnectionPolicy setIdleEndpointTimeout(Duration idleEndpointTimeout) {
        this.idleEndpointTimeout = idleEndpointTimeout;
        return this;
    }

    public int getMaxChannelsPerEndpoint() {
        return this.maxChannelsPerEndpoint;
    }

    public ConnectionPolicy setMaxChannelsPerEndpoint(int maxChannelsPerEndpoint) {
        this.maxChannelsPerEndpoint = maxChannelsPerEndpoint;
        return this;
    }

    public int getMaxRequestsPerChannel() {
        return this.maxRequestsPerChannel;
    }

    public ConnectionPolicy setMaxRequestsPerChannel(int maxRequestsPerChannel) {
        this.maxRequestsPerChannel = maxRequestsPerChannel;
        return this;
    }

    public String toString() {
        return "ConnectionPolicy{requestTimeout=" + this.requestTimeout + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", maxConnectionPoolSize=" + this.maxConnectionPoolSize + ", idleConnectionTimeout=" + this.idleConnectionTimeout + ", userAgentSuffix='" + this.userAgentSuffix + '\'' + ", throttlingRetryOptions=" + this.throttlingRetryOptions + ", endpointDiscoveryEnabled=" + this.endpointDiscoveryEnabled + ", preferredRegions=" + this.preferredRegions + ", multipleWriteRegionsEnabled=" + this.multipleWriteRegionsEnabled + ", inetSocketProxyAddress=" + this.inetSocketProxyAddress + ", readRequestsFallbackEnabled=" + this.readRequestsFallbackEnabled + ", connectionTimeout=" + this.connectionTimeout + ", idleChannelTimeout=" + this.idleChannelTimeout + ", idleEndpointTimeout=" + this.idleEndpointTimeout + ", maxChannelsPerEndpoint=" + this.maxChannelsPerEndpoint + ", maxRequestsPerChannel=" + this.maxRequestsPerChannel + '}';
    }
}

