/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.ReplicationPolicy;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.ObjectUtils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.ConsistencyPolicy;
import com.azure.cosmos.models.DatabaseAccountLocation;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class DatabaseAccount
extends Resource {
    private ConsistencyPolicy consistencyPolicy;
    private long maxMediaStorageUsageInMB;
    private long mediaStorageUsageInMB;
    private ReplicationPolicy replicationPolicy;
    private ReplicationPolicy systemReplicationPolicy;
    private Map<String, Object> queryEngineConfiguration;

    DatabaseAccount(ObjectNode objectNode) {
        super(objectNode);
    }

    public DatabaseAccount() {
        BridgeInternal.setResourceSelfLink(this, "");
    }

    public DatabaseAccount(String jsonString) {
        super(jsonString);
    }

    String getDatabasesLink() {
        return super.getString("_dbs");
    }

    void setDatabasesLink(String databasesLink) {
        BridgeInternal.setProperty(this, "_dbs", databasesLink);
    }

    String getMediaLink() {
        return super.getString("media");
    }

    void setMediaLink(String medialink) {
        BridgeInternal.setProperty(this, "media", medialink);
    }

    String getAddressesLink() {
        return super.getString("addresses");
    }

    void setAddressesLink(String addresseslink) {
        BridgeInternal.setProperty(this, "addresses", addresseslink);
    }

    long getMaxMediaStorageUsageInMB() {
        return this.maxMediaStorageUsageInMB;
    }

    public void setMaxMediaStorageUsageInMB(long value) {
        this.maxMediaStorageUsageInMB = value;
    }

    long getMediaStorageUsageInMB() {
        return this.mediaStorageUsageInMB;
    }

    public void setMediaStorageUsageInMB(long value) {
        this.mediaStorageUsageInMB = value;
    }

    public ConsistencyPolicy getConsistencyPolicy() {
        if (this.consistencyPolicy == null) {
            this.consistencyPolicy = super.getObject("userConsistencyPolicy", ConsistencyPolicy.class, new boolean[0]);
            if (this.consistencyPolicy == null) {
                this.consistencyPolicy = new ConsistencyPolicy();
            }
        }
        return this.consistencyPolicy;
    }

    public ReplicationPolicy getReplicationPolicy() {
        if (this.replicationPolicy == null) {
            this.replicationPolicy = super.getObject("userReplicationPolicy", ReplicationPolicy.class, new boolean[0]);
            if (this.replicationPolicy == null) {
                this.replicationPolicy = new ReplicationPolicy();
            }
        }
        return this.replicationPolicy;
    }

    public ReplicationPolicy getSystemReplicationPolicy() {
        if (this.systemReplicationPolicy == null) {
            this.systemReplicationPolicy = super.getObject("systemReplicationPolicy", ReplicationPolicy.class, new boolean[0]);
            if (this.systemReplicationPolicy == null) {
                this.systemReplicationPolicy = new ReplicationPolicy();
            }
        }
        return this.systemReplicationPolicy;
    }

    public Map<String, Object> getQueryEngineConfiguration() {
        String queryEngineConfigurationJsonString;
        if (this.queryEngineConfiguration == null && StringUtils.isNotEmpty(queryEngineConfigurationJsonString = super.getObject("queryEngineConfiguration", String.class, new boolean[0]))) {
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            try {
                this.queryEngineConfiguration = (Map)Utils.getSimpleObjectMapper().readValue(queryEngineConfigurationJsonString, (TypeReference)typeRef);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            if (this.queryEngineConfiguration == null) {
                this.queryEngineConfiguration = new HashMap<String, Object>();
            }
        }
        return this.queryEngineConfiguration;
    }

    public Iterable<DatabaseAccountLocation> getWritableLocations() {
        return super.getCollection("writableLocations", DatabaseAccountLocation.class, new boolean[0]);
    }

    public void setWritableLocations(Iterable<DatabaseAccountLocation> locations) {
        BridgeInternal.setProperty(this, "writableLocations", locations);
    }

    public Iterable<DatabaseAccountLocation> getReadableLocations() {
        return super.getCollection("readableLocations", DatabaseAccountLocation.class, new boolean[0]);
    }

    public void setReadableLocations(Iterable<DatabaseAccountLocation> locations) {
        BridgeInternal.setProperty(this, "readableLocations", locations);
    }

    public boolean getEnableMultipleWriteLocations() {
        return ObjectUtils.defaultIfNull(super.getBoolean("enableMultipleWriteLocations"), false);
    }

    public void setEnableMultipleWriteLocations(boolean value) {
        BridgeInternal.setProperty(this, "enableMultipleWriteLocations", value);
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        if (this.consistencyPolicy != null) {
            ModelBridgeInternal.populatePropertyBag(this.consistencyPolicy);
            BridgeInternal.setProperty(this, "userConsistencyPolicy", this.consistencyPolicy);
        }
    }

    @Override
    public String toJson() {
        this.populatePropertyBag();
        return super.toJson();
    }

    @Override
    public Object get(String propertyName) {
        return super.get(propertyName);
    }
}

