/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class Resource
extends JsonSerializable {
    private String altLink;

    public static void validateResource(Resource resource) {
        if (!StringUtils.isEmpty(resource.getId())) {
            if (resource.getId().indexOf(47) != -1 || resource.getId().indexOf(92) != -1 || resource.getId().indexOf(63) != -1 || resource.getId().indexOf(35) != -1) {
                throw new IllegalArgumentException("Id contains illegal chars.");
            }
            if (resource.getId().endsWith(" ")) {
                throw new IllegalArgumentException("Id ends with a space.");
            }
        }
    }

    protected Resource(Resource resource) {
        this.setId(resource.getId());
        this.setResourceId(resource.getResourceId());
        this.setSelfLink(resource.getSelfLink());
        this.setAltLink(resource.getAltLink());
        this.setTimestamp(resource.getTimestamp());
        this.setETag(resource.getETag());
    }

    protected Resource() {
    }

    protected Resource(ObjectNode objectNode) {
        super(objectNode);
    }

    Resource(String jsonString, ObjectMapper objectMapper) {
        super(jsonString, objectMapper);
    }

    protected Resource(String jsonString) {
        super(jsonString);
    }

    protected Resource(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    protected Resource(byte[] bytes) {
        super(bytes);
    }

    public String getId() {
        return super.getString("id");
    }

    public Resource setId(String id) {
        super.set("id", id);
        return this;
    }

    public String getResourceId() {
        return super.getString("_rid");
    }

    public Resource setResourceId(String resourceId) {
        super.set("_rid", resourceId);
        return this;
    }

    public String getSelfLink() {
        return super.getString("_self");
    }

    public Resource setSelfLink(String selfLink) {
        super.set("_self", selfLink);
        return this;
    }

    public OffsetDateTime getTimestamp() {
        Long seconds = super.getLong("_ts");
        if (seconds == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(seconds), ZoneOffset.UTC);
    }

    public Resource setTimestamp(OffsetDateTime timestamp) {
        long seconds = timestamp.toEpochSecond();
        super.set("_ts", seconds);
        return this;
    }

    public String getETag() {
        return super.getString("_etag");
    }

    Resource setETag(String eTag) {
        super.set("_etag", eTag);
        return this;
    }

    public Resource setAltLink(String altLink) {
        this.altLink = altLink;
        return this;
    }

    public String getAltLink() {
        return this.altLink;
    }
}

