/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosResponseDiagnostics;
import com.azure.cosmos.implementation.Conflict;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.implementation.User;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.directconnectivity.Address;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RxDocumentServiceResponse {
    private final int statusCode;
    private final Map<String, String> headersMap;
    private final StoreResponse storeResponse;

    public RxDocumentServiceResponse(StoreResponse response) {
        String[] headerNames = response.getResponseHeaderNames();
        String[] headerValues = response.getResponseHeaderValues();
        this.headersMap = new HashMap<String, String>(headerNames.length);
        this.statusCode = response.getStatus();
        for (int i = 0; i < headerNames.length; ++i) {
            this.headersMap.put(headerNames[i], headerValues[i]);
        }
        this.storeResponse = response;
    }

    public static <T extends Resource> String getResourceKey(Class<T> c) {
        if (c.equals(Conflict.class)) {
            return "Conflicts";
        }
        if (c.equals(Database.class)) {
            return "Databases";
        }
        if (Document.class.isAssignableFrom(c)) {
            return "Documents";
        }
        if (c.equals(DocumentCollection.class)) {
            return "DocumentCollections";
        }
        if (c.equals(Offer.class)) {
            return "Offers";
        }
        if (c.equals(Permission.class)) {
            return "Permissions";
        }
        if (c.equals(Trigger.class)) {
            return "Triggers";
        }
        if (c.equals(StoredProcedure.class)) {
            return "StoredProcedures";
        }
        if (c.equals(User.class)) {
            return "Users";
        }
        if (c.equals(UserDefinedFunction.class)) {
            return "UserDefinedFunctions";
        }
        if (c.equals(Address.class)) {
            return "Addresss";
        }
        if (c.equals(PartitionKeyRange.class)) {
            return "PartitionKeyRanges";
        }
        throw new IllegalArgumentException("c");
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, String> getResponseHeaders() {
        return this.headersMap;
    }

    public byte[] getResponseBodyAsByteArray() {
        return this.storeResponse.getResponseBody();
    }

    public String getResponseBodyAsString() {
        return Utils.utf8StringFromOrNull(this.getResponseBodyAsByteArray());
    }

    public <T extends Resource> T getResource(Class<T> c) {
        String responseBody = this.getResponseBodyAsString();
        if (StringUtils.isEmpty(responseBody)) {
            return null;
        }
        Resource resource = null;
        try {
            resource = (Resource)c.getConstructor(String.class).newInstance(responseBody);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate class object.", e);
        }
        if (PathsHelper.isPublicResource(resource)) {
            BridgeInternal.setAltLink(resource, PathsHelper.generatePathForNameBased(resource, this.getOwnerFullName(), resource.getId()));
        }
        return (T)resource;
    }

    public <T extends Resource> List<T> getQueryResponse(Class<T> c) {
        ArrayNode innerArray;
        byte[] responseBody = this.getResponseBodyAsByteArray();
        if (responseBody == null) {
            return new ArrayList();
        }
        JsonNode jobject = RxDocumentServiceResponse.fromJson(responseBody);
        String resourceKey = RxDocumentServiceResponse.getResourceKey(c);
        ArrayNode jTokenArray = (ArrayNode)jobject.get(resourceKey);
        while (jTokenArray != null && jTokenArray.size() == 1 && (innerArray = this.toArrayNode(jTokenArray.get(0))) != null) {
            jTokenArray = innerArray;
        }
        ArrayList<Resource> queryResults = new ArrayList<Resource>();
        if (jTokenArray != null) {
            for (int i = 0; i < jTokenArray.size(); ++i) {
                JsonNode jToken = jTokenArray.get(i);
                JsonNode resourceJson = jToken.isValueNode() || jToken.isArray() ? RxDocumentServiceResponse.fromJson(String.format("{\"%s\": %s}", "_value", jToken.toString())) : jToken;
                Resource resource = (Resource)ModelBridgeInternal.instantiateJsonSerializable((ObjectNode)resourceJson, c);
                queryResults.add(resource);
            }
        }
        return queryResults;
    }

    private ArrayNode toArrayNode(JsonNode n) {
        if (n.isArray()) {
            return (ArrayNode)n;
        }
        return null;
    }

    private static JsonNode fromJson(String json) {
        try {
            return Utils.getSimpleObjectMapper().readTree(json);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to parse JSON %s", json), e);
        }
    }

    private static JsonNode fromJson(byte[] json) {
        try {
            return Utils.getSimpleObjectMapper().readTree(json);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to parse JSON %s", Arrays.toString(json)), e);
        }
    }

    private String getOwnerFullName() {
        if (this.headersMap != null) {
            return this.headersMap.get("x-ms-alt-content-path");
        }
        return null;
    }

    CosmosResponseDiagnostics getCosmosResponseRequestDiagnosticStatistics() {
        if (this.storeResponse == null) {
            return null;
        }
        return this.storeResponse.getCosmosResponseDiagnostics();
    }
}

