/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed;

import com.azure.cosmos.implementation.CosmosItemProperties;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=ServiceItemLeaseJsonSerializer.class)
public class ServiceItemLease
implements Lease {
    private static final ZonedDateTime UNIX_START_TIME = ZonedDateTime.parse("1970-01-01T00:00:00.0Z[UTC]");
    private static final String PROPERTY_NAME_LEASE_TOKEN = "LeaseToken";
    private static final String PROPERTY_NAME_CONTINUATION_TOKEN = "ContinuationToken";
    private static final String PROPERTY_NAME_TIMESTAMP = "timestamp";
    private static final String PROPERTY_NAME_OWNER = "Owner";
    private String id;
    private String _etag;
    private String LeaseToken;
    private String Owner;
    private String ContinuationToken;
    private Map<String, String> properties;
    private String timestamp;
    private String _ts;

    public ServiceItemLease() {
        ZonedDateTime currentTime = ZonedDateTime.now(ZoneId.of("UTC"));
        this.timestamp = currentTime.toString();
        this._ts = String.valueOf(currentTime.getSecond());
        this.properties = new HashMap<String, String>();
    }

    public ServiceItemLease(ServiceItemLease other) {
        this.id = other.id;
        this._etag = other._etag;
        this.LeaseToken = other.LeaseToken;
        this.Owner = other.Owner;
        this.ContinuationToken = other.ContinuationToken;
        this.properties = other.properties;
        this.timestamp = other.timestamp;
        this._ts = other._ts;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ServiceItemLease withId(String id) {
        this.id = id;
        return this;
    }

    public String getETag() {
        return this._etag;
    }

    public ServiceItemLease withETag(String etag) {
        this._etag = etag;
        return this;
    }

    @Override
    public String getLeaseToken() {
        return this.LeaseToken;
    }

    public ServiceItemLease withLeaseToken(String leaseToken) {
        this.LeaseToken = leaseToken;
        return this;
    }

    @Override
    public String getOwner() {
        return this.Owner;
    }

    public ServiceItemLease withOwner(String owner) {
        this.Owner = owner;
        return this;
    }

    @Override
    public String getContinuationToken() {
        return this.ContinuationToken;
    }

    @Override
    public void setContinuationToken(String continuationToken) {
        this.withContinuationToken(continuationToken);
    }

    public ServiceItemLease withContinuationToken(String continuationToken) {
        this.ContinuationToken = continuationToken;
        return this;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setOwner(String owner) {
        this.withOwner(owner);
    }

    @Override
    public void setTimestamp(ZonedDateTime timestamp) {
        this.withTimestamp(timestamp);
    }

    public void setTimestamp(Date date) {
        this.withTimestamp(date.toInstant().atZone(ZoneId.systemDefault()));
    }

    public void setTimestamp(Date date, ZoneId zoneId) {
        this.withTimestamp(date.toInstant().atZone(zoneId));
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void setId(String id) {
        this.withId(id);
    }

    @Override
    public void setConcurrencyToken(String concurrencyToken) {
        this.withETag(concurrencyToken);
    }

    public ServiceItemLease withConcurrencyToken(String concurrencyToken) {
        return this.withETag(concurrencyToken);
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.withProperties(properties);
    }

    public ServiceItemLease withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public String getTs() {
        return this._ts;
    }

    public ServiceItemLease withTs(String ts) {
        this._ts = ts;
        return this;
    }

    @Override
    public String getTimestamp() {
        if (this.timestamp == null) {
            return UNIX_START_TIME.plusSeconds(Long.parseLong(this.getTs())).toString();
        }
        return this.timestamp;
    }

    public ServiceItemLease withTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp.toString();
        return this;
    }

    public String getExplicitTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getConcurrencyToken() {
        return this.getETag();
    }

    public static ServiceItemLease fromDocument(CosmosItemProperties document) {
        ServiceItemLease lease = new ServiceItemLease().withId(document.getId()).withETag(document.getETag()).withTs(ModelBridgeInternal.getStringFromJsonSerializable(document, "_ts")).withOwner(ModelBridgeInternal.getStringFromJsonSerializable(document, PROPERTY_NAME_OWNER)).withLeaseToken(ModelBridgeInternal.getStringFromJsonSerializable(document, PROPERTY_NAME_LEASE_TOKEN)).withContinuationToken(ModelBridgeInternal.getStringFromJsonSerializable(document, PROPERTY_NAME_CONTINUATION_TOKEN));
        String leaseTimestamp = ModelBridgeInternal.getStringFromJsonSerializable(document, PROPERTY_NAME_TIMESTAMP);
        if (leaseTimestamp != null) {
            return lease.withTimestamp(ZonedDateTime.parse(leaseTimestamp));
        }
        return lease;
    }

    @Override
    public void setServiceItemLease(Lease lease) {
        this.setId(lease.getId());
        this.setConcurrencyToken(lease.getConcurrencyToken());
        this.setOwner(lease.getOwner());
        this.withLeaseToken(lease.getLeaseToken());
        this.setContinuationToken(this.getContinuationToken());
        String leaseTimestamp = lease.getTimestamp();
        if (leaseTimestamp != null) {
            this.setTimestamp(ZonedDateTime.parse(leaseTimestamp));
        } else {
            this.setTimestamp(lease.getTimestamp());
        }
    }

    public String toString() {
        return String.format("%s Owner='%s' Continuation=%s Timestamp(local)=%s Timestamp(server)=%s", this.getId(), this.getOwner(), this.getContinuationToken(), this.getTimestamp(), UNIX_START_TIME.plusSeconds(Long.parseLong(this.getTs())));
    }

    static final class ServiceItemLeaseJsonSerializer
    extends StdSerializer<ServiceItemLease> {
        private static final long serialVersionUID = 1L;

        protected ServiceItemLeaseJsonSerializer() {
            this(null);
        }

        protected ServiceItemLeaseJsonSerializer(Class<ServiceItemLease> t) {
            super(t);
        }

        public void serialize(ServiceItemLease lease, JsonGenerator writer, SerializerProvider serializerProvider) {
            try {
                writer.writeStartObject();
                writer.writeStringField("id", lease.getId());
                writer.writeStringField("_etag", lease.getETag());
                writer.writeStringField(ServiceItemLease.PROPERTY_NAME_LEASE_TOKEN, lease.getLeaseToken());
                writer.writeStringField(ServiceItemLease.PROPERTY_NAME_CONTINUATION_TOKEN, lease.getContinuationToken());
                writer.writeStringField(ServiceItemLease.PROPERTY_NAME_TIMESTAMP, lease.getTimestamp());
                writer.writeStringField(ServiceItemLease.PROPERTY_NAME_OWNER, lease.getOwner());
                writer.writeEndObject();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

