/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.DistinctQueryType;
import com.azure.cosmos.implementation.query.OrderedDistinctMap;
import com.azure.cosmos.implementation.query.UnorderedDistinctMap;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public abstract class DistinctMap {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    public static DistinctMap create(DistinctQueryType distinctQueryType, String previousHash) {
        switch (distinctQueryType) {
            case NONE: {
                throw new IllegalArgumentException("distinct query type cannot be None");
            }
            case UNORDERED: {
                return new UnorderedDistinctMap();
            }
            case ORDERED: {
                return new OrderedDistinctMap(previousHash);
            }
        }
        throw new IllegalArgumentException("Unrecognized DistinctQueryType");
    }

    public abstract boolean add(Resource var1, Utils.ValueHolder<String> var2);

    String getHash(Resource resource) throws JsonProcessingException, NoSuchAlgorithmException {
        Object obj = OBJECT_MAPPER.treeToValue((TreeNode)ModelBridgeInternal.getPropertyBagFromJsonSerializable(resource), Object.class);
        String sortedJson = OBJECT_MAPPER.writeValueAsString(obj);
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] digest = md.digest(sortedJson.getBytes(Charset.defaultCharset()));
        return Base64.getEncoder().encodeToString(digest);
    }
}

