/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.guava25.base.CaseFormat;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;

public final class ConsistencyPolicy {
    private static final ConsistencyLevel DEFAULT_DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.SESSION;
    private static final int DEFAULT_MAX_STALENESS_INTERVAL = 5;
    private static final int DEFAULT_MAX_STALENESS_PREFIX = 100;
    private JsonSerializable jsonSerializable;

    public ConsistencyPolicy() {
        this.jsonSerializable = new JsonSerializable();
    }

    ConsistencyPolicy(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    ConsistencyPolicy(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    public ConsistencyLevel getDefaultConsistencyLevel() {
        ConsistencyLevel result = DEFAULT_DEFAULT_CONSISTENCY_LEVEL;
        String consistencyLevelString = this.jsonSerializable.getString("defaultConsistencyLevel");
        try {
            result = ConsistencyLevel.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, consistencyLevelString));
        }
        catch (IllegalArgumentException e) {
            this.jsonSerializable.getLogger().warn("Unknown consistency level {}, value ignored.", (Object)consistencyLevelString);
        }
        return result;
    }

    public ConsistencyPolicy setDefaultConsistencyLevel(ConsistencyLevel level) {
        this.jsonSerializable.set("defaultConsistencyLevel", level.toString());
        return this;
    }

    public int getMaxStalenessPrefix() {
        Integer value = this.jsonSerializable.getInt("maxStalenessPrefix");
        if (value == null) {
            return 100;
        }
        return value;
    }

    public ConsistencyPolicy setMaxStalenessPrefix(int maxStalenessPrefix) {
        this.jsonSerializable.set("maxStalenessPrefix", maxStalenessPrefix);
        return this;
    }

    public Duration getMaxStalenessInterval() {
        Integer value = this.jsonSerializable.getInt("maxIntervalInSeconds");
        if (value == null) {
            return Duration.ofSeconds(5L);
        }
        return Duration.ofSeconds(value.intValue());
    }

    public ConsistencyPolicy setMaxStalenessInterval(Duration maxStalenessInterval) {
        if (maxStalenessInterval == null) {
            throw new IllegalArgumentException("maxStalenessInterval should not be null");
        }
        this.jsonSerializable.set("maxIntervalInSeconds", maxStalenessInterval.getSeconds());
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

