/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncConflict;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.Conflict;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.CosmosConflictProperties;
import com.azure.cosmos.models.CosmosResponse;

public class CosmosAsyncConflictResponse
extends CosmosResponse<CosmosConflictProperties> {
    private final CosmosAsyncContainer container;
    private final CosmosAsyncConflict conflictClient;

    CosmosAsyncConflictResponse(ResourceResponse<Conflict> response, CosmosAsyncContainer container) {
        super(response);
        this.container = container;
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty(bodyAsString)) {
            super.setProperties(null);
            this.conflictClient = null;
        } else {
            CosmosConflictProperties props = new CosmosConflictProperties(bodyAsString);
            super.setProperties(props);
            this.conflictClient = BridgeInternal.createCosmosAsyncConflict(props.getId(), container);
        }
    }

    CosmosAsyncContainer getContainer() {
        return this.container;
    }

    public CosmosAsyncConflict getConflict() {
        return this.conflictClient;
    }

    @Override
    public CosmosConflictProperties getProperties() {
        return this.getProperties();
    }
}

