/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.models.CosmosAsyncDatabaseResponse;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosResponse;

public class CosmosDatabaseResponse
extends CosmosResponse<CosmosDatabaseProperties> {
    private final CosmosAsyncDatabaseResponse responseWrapper;
    private final CosmosDatabase database;

    CosmosDatabaseResponse(CosmosAsyncDatabaseResponse response, CosmosClient client) {
        super(response.resourceResponseWrapper, response.getProperties());
        this.responseWrapper = response;
        this.database = this.responseWrapper.getDatabase() != null ? BridgeInternal.createCosmosDatabase(this.responseWrapper.getDatabase().getId(), client, this.responseWrapper.getDatabase()) : null;
    }

    public CosmosDatabase getDatabase() {
        return this.database;
    }

    @Override
    public CosmosDatabaseProperties getProperties() {
        return this.responseWrapper.getProperties();
    }

    public long getDatabaseQuota() {
        return this.responseWrapper.getDatabaseQuota();
    }

    public long getDatabaseUsage() {
        return this.responseWrapper.getDatabaseUsage();
    }
}

