/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.JsonSerializable;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class CosmosError {
    private JsonSerializable jsonSerializable;

    public CosmosError() {
        this.jsonSerializable = new JsonSerializable();
    }

    CosmosError(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    CosmosError(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    public CosmosError(String errorCode, String message) {
        this(errorCode, message, null);
    }

    public CosmosError(String errorCode, String message, String additionalErrorInfo) {
        this.jsonSerializable = new JsonSerializable();
        this.setCode(errorCode);
        this.setMessage(message);
        this.setAdditionalErrorInfo(additionalErrorInfo);
    }

    public String getCode() {
        return this.jsonSerializable.getString("code");
    }

    private void setCode(String code) {
        this.jsonSerializable.set("code", code);
    }

    public String getMessage() {
        return this.jsonSerializable.getString("message");
    }

    private void setMessage(String message) {
        this.jsonSerializable.set("message", message);
    }

    public String getErrorDetails() {
        return this.jsonSerializable.getString("errorDetails");
    }

    private void setAdditionalErrorInfo(String additionalErrorInfo) {
        this.jsonSerializable.set("additionalErrorInfo", additionalErrorInfo);
    }

    public String getPartitionedQueryExecutionInfo() {
        return this.jsonSerializable.getString("additionalErrorInfo");
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

