/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PermissionMode;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosPermissionProperties {
    private Permission permission;

    static List<CosmosPermissionProperties> getFromV2Results(List<Permission> results) {
        return results.stream().map(permission -> new CosmosPermissionProperties(permission.toJson())).collect(Collectors.toList());
    }

    public CosmosPermissionProperties() {
        this.permission = new Permission();
    }

    public CosmosPermissionProperties setId(String id) {
        this.permission.setId(id);
        return this;
    }

    CosmosPermissionProperties(String jsonString) {
        this.permission = new Permission(jsonString);
    }

    public String getResourceLink() {
        return this.permission.getResourceLink();
    }

    public CosmosPermissionProperties setResourceLink(String resourceLink) {
        this.permission.setResourceLink(resourceLink);
        return this;
    }

    public PermissionMode getPermissionMode() {
        return this.permission.getPermissionMode();
    }

    public CosmosPermissionProperties setPermissionMode(PermissionMode permissionMode) {
        this.permission.setPermissionMode(permissionMode);
        return this;
    }

    public PartitionKey getResourcePartitionKey() {
        return this.permission.getResourcePartitionKey();
    }

    public CosmosPermissionProperties setResourcePartitionKey(PartitionKey partitionKey) {
        this.permission.setResourcePartitionKey(partitionKey);
        return this;
    }

    Resource getResource() {
        return this.permission;
    }

    public String getId() {
        return this.permission.getId();
    }

    public String getResourceId() {
        return this.permission.getResourceId();
    }

    public OffsetDateTime getTimestamp() {
        return this.permission.getTimestamp();
    }

    public String getETag() {
        return this.permission.getETag();
    }

    Permission getV2Permissions() {
        return new Permission(this.permission.toJson());
    }
}

