/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.StoredProcedure;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosStoredProcedureProperties {
    private StoredProcedure storedProcedure;

    public CosmosStoredProcedureProperties() {
        this.storedProcedure = new StoredProcedure();
    }

    public CosmosStoredProcedureProperties setId(String id) {
        this.storedProcedure.setId(id);
        return this;
    }

    CosmosStoredProcedureProperties(String jsonString) {
        this.storedProcedure = new StoredProcedure(jsonString);
    }

    public CosmosStoredProcedureProperties(String id, String body) {
        this.storedProcedure = new StoredProcedure();
        this.storedProcedure.setId(id);
        this.storedProcedure.setBody(body);
    }

    public String getBody() {
        return this.storedProcedure.getBody();
    }

    public CosmosStoredProcedureProperties setBody(String body) {
        this.storedProcedure.setBody(body);
        return this;
    }

    Resource getResource() {
        return this.storedProcedure;
    }

    public String getId() {
        return this.storedProcedure.getId();
    }

    public String getResourceId() {
        return this.storedProcedure.getResourceId();
    }

    public OffsetDateTime getTimestamp() {
        return this.storedProcedure.getTimestamp();
    }

    public String getETag() {
        return this.storedProcedure.getETag();
    }

    static List<CosmosStoredProcedureProperties> getFromV2Results(List<StoredProcedure> results) {
        return results.stream().map(sproc -> new CosmosStoredProcedureProperties(sproc.toJson())).collect(Collectors.toList());
    }
}

