/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.User;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosUserProperties {
    private User user;

    public CosmosUserProperties() {
        this.user = new User();
    }

    public CosmosUserProperties setId(String id) {
        this.user.setId(id);
        return this;
    }

    CosmosUserProperties(String jsonString) {
        this.user = new User(jsonString);
    }

    CosmosUserProperties(User user) {
        this.user = user;
    }

    String getPermissionsLink() {
        return this.user.getPermissionsLink();
    }

    User getV2User() {
        return new User(this.user.toJson());
    }

    Resource getResource() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getResourceId() {
        return this.user.getResourceId();
    }

    public OffsetDateTime getTimestamp() {
        return this.user.getTimestamp();
    }

    public String getETag() {
        return this.user.getETag();
    }

    static List<CosmosUserProperties> getFromV2Results(List<User> results) {
        return results.stream().map(CosmosUserProperties::new).collect(Collectors.toList());
    }
}

