/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.models.PartitionKey;
import java.util.Map;

public final class FeedOptions {
    private String sessionToken;
    private String partitionKeyRangeId;
    private Boolean scanInQueryEnabled;
    private Boolean emitVerboseTracesInQuery;
    private int maxDegreeOfParallelism;
    private int maxBufferedItemCount;
    private int responseContinuationTokenLimitInKb;
    private Integer maxItemCount;
    private String requestContinuation;
    private PartitionKey partitionkey;
    private boolean populateQueryMetrics;
    private Map<String, Object> properties;
    private boolean emptyPagesAllowed;

    public FeedOptions() {
    }

    public FeedOptions(FeedOptions options) {
        this.sessionToken = options.sessionToken;
        this.partitionKeyRangeId = options.partitionKeyRangeId;
        this.scanInQueryEnabled = options.scanInQueryEnabled;
        this.emitVerboseTracesInQuery = options.emitVerboseTracesInQuery;
        this.maxDegreeOfParallelism = options.maxDegreeOfParallelism;
        this.maxBufferedItemCount = options.maxBufferedItemCount;
        this.responseContinuationTokenLimitInKb = options.responseContinuationTokenLimitInKb;
        this.maxItemCount = options.maxItemCount;
        this.requestContinuation = options.requestContinuation;
        this.partitionkey = options.partitionkey;
        this.populateQueryMetrics = options.populateQueryMetrics;
        this.emptyPagesAllowed = options.emptyPagesAllowed;
    }

    String getPartitionKeyRangeIdInternal() {
        return this.partitionKeyRangeId;
    }

    FeedOptions setPartitionKeyRangeIdInternal(String partitionKeyRangeId) {
        this.partitionKeyRangeId = partitionKeyRangeId;
        return this;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public FeedOptions setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public Boolean isScanInQueryEnabled() {
        return this.scanInQueryEnabled;
    }

    public FeedOptions setScanInQueryEnabled(Boolean scanInQueryEnabled) {
        this.scanInQueryEnabled = scanInQueryEnabled;
        return this;
    }

    public Boolean isEmitVerboseTracesInQuery() {
        return this.emitVerboseTracesInQuery;
    }

    public FeedOptions setEmitVerboseTracesInQuery(Boolean emitVerboseTracesInQuery) {
        this.emitVerboseTracesInQuery = emitVerboseTracesInQuery;
        return this;
    }

    public int getMaxDegreeOfParallelism() {
        return this.maxDegreeOfParallelism;
    }

    public FeedOptions setMaxDegreeOfParallelism(int maxDegreeOfParallelism) {
        this.maxDegreeOfParallelism = maxDegreeOfParallelism;
        return this;
    }

    public int getMaxBufferedItemCount() {
        return this.maxBufferedItemCount;
    }

    public FeedOptions setMaxBufferedItemCount(int maxBufferedItemCount) {
        this.maxBufferedItemCount = maxBufferedItemCount;
        return this;
    }

    public FeedOptions getResponseContinuationTokenLimitInKb(int limitInKb) {
        this.responseContinuationTokenLimitInKb = limitInKb;
        return this;
    }

    public int setResponseContinuationTokenLimitInKb() {
        return this.responseContinuationTokenLimitInKb;
    }

    public Integer getMaxItemCount() {
        return this.maxItemCount;
    }

    FeedOptions setMaxItemCount(Integer maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public String getRequestContinuation() {
        return this.requestContinuation;
    }

    FeedOptions setRequestContinuation(String requestContinuation) {
        this.requestContinuation = requestContinuation;
        return this;
    }

    public PartitionKey getPartitionKey() {
        return this.partitionkey;
    }

    public FeedOptions setPartitionKey(PartitionKey partitionkey) {
        this.partitionkey = partitionkey;
        return this;
    }

    public boolean isPopulateQueryMetrics() {
        return this.populateQueryMetrics;
    }

    public FeedOptions setPopulateQueryMetrics(boolean populateQueryMetrics) {
        this.populateQueryMetrics = populateQueryMetrics;
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public FeedOptions setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public boolean isEmptyPagesAllowed() {
        return this.emptyPagesAllowed;
    }

    public FeedOptions setEmptyPagesAllowed(boolean emptyPagesAllowed) {
        this.emptyPagesAllowed = emptyPagesAllowed;
        return this;
    }
}

