/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.IndexKind;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.DataType;
import com.azure.cosmos.models.Index;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class HashIndex
extends Index {
    HashIndex(DataType dataType) {
        super(IndexKind.HASH);
        this.setDataType(dataType);
    }

    HashIndex(DataType dataType, int precision) {
        super(IndexKind.HASH);
        this.setDataType(dataType);
        this.setPrecision(precision);
    }

    HashIndex(String jsonString) {
        super(jsonString, IndexKind.HASH);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    HashIndex(ObjectNode objectNode) {
        super(objectNode, IndexKind.HASH);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public DataType getDataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(StringUtils.upperCase(this.jsonSerializable.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            this.jsonSerializable.getLogger().warn("INVALID index dataType value {}.", (Object)this.jsonSerializable.getString("dataType"));
        }
        return result;
    }

    public HashIndex setDataType(DataType dataType) {
        this.jsonSerializable.set("dataType", dataType.toString());
        return this;
    }

    public int getPrecision() {
        return this.jsonSerializable.getInt("precision");
    }

    public HashIndex setPrecision(int precision) {
        this.jsonSerializable.set("precision", precision);
        return this;
    }

    boolean hasPrecision() {
        return this.jsonSerializable.has("precision");
    }
}

