/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.IndexKind;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.DataType;
import com.azure.cosmos.models.HashIndex;
import com.azure.cosmos.models.RangeIndex;
import com.azure.cosmos.models.SpatialIndex;
import com.fasterxml.jackson.databind.node.ObjectNode;

public abstract class Index {
    JsonSerializable jsonSerializable;

    Index(IndexKind indexKind) {
        this.jsonSerializable = new JsonSerializable();
        this.setKind(indexKind);
    }

    Index(String jsonString, IndexKind indexKind) {
        this.jsonSerializable = new JsonSerializable(jsonString);
        this.setKind(indexKind);
    }

    Index(ObjectNode objectNode, IndexKind indexKind) {
        this.jsonSerializable = new JsonSerializable(objectNode);
        this.setKind(indexKind);
    }

    public static RangeIndex range(DataType dataType) {
        return new RangeIndex(dataType);
    }

    public static RangeIndex range(DataType dataType, int precision) {
        return new RangeIndex(dataType, precision);
    }

    public static HashIndex hash(DataType dataType) {
        return new HashIndex(dataType);
    }

    public static HashIndex hash(DataType dataType, int precision) {
        return new HashIndex(dataType, precision);
    }

    public static SpatialIndex spatial(DataType dataType) {
        return new SpatialIndex(dataType);
    }

    IndexKind getKind() {
        IndexKind result = null;
        try {
            result = IndexKind.valueOf(StringUtils.upperCase(this.jsonSerializable.getString("kind")));
        }
        catch (IllegalArgumentException e) {
            this.jsonSerializable.getLogger().warn("INVALID index kind value %s.", (Object)this.jsonSerializable.getString("kind"));
        }
        return result;
    }

    private Index setKind(IndexKind indexKind) {
        this.jsonSerializable.set("kind", indexKind.toString());
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

