/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.IndexKind;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.DataType;
import com.azure.cosmos.models.Index;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class RangeIndex
extends Index {
    RangeIndex(DataType dataType) {
        super(IndexKind.RANGE);
        this.setDataType(dataType);
    }

    RangeIndex(DataType dataType, int precision) {
        super(IndexKind.RANGE);
        this.setDataType(dataType);
        this.setPrecision(precision);
    }

    RangeIndex(String jsonString) {
        super(jsonString, IndexKind.RANGE);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    RangeIndex(ObjectNode objectNode) {
        super(objectNode, IndexKind.RANGE);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public DataType getDataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(StringUtils.upperCase(this.jsonSerializable.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            this.jsonSerializable.getLogger().warn("INVALID index dataType value {}.", (Object)this.jsonSerializable.getString("dataType"));
        }
        return result;
    }

    public RangeIndex setDataType(DataType dataType) {
        this.jsonSerializable.set("dataType", dataType.toString());
        return this;
    }

    public int getPrecision() {
        return this.jsonSerializable.getInt("precision");
    }

    public RangeIndex setPrecision(int precision) {
        this.jsonSerializable.set("precision", precision);
        return this;
    }

    boolean hasPrecision() {
        return this.jsonSerializable.has("precision");
    }
}

