/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.IndexKind;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.DataType;
import com.azure.cosmos.models.Index;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class SpatialIndex
extends Index {
    SpatialIndex(DataType dataType) {
        super(IndexKind.SPATIAL);
        this.setDataType(dataType);
    }

    SpatialIndex(String jsonString) {
        super(jsonString, IndexKind.SPATIAL);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    SpatialIndex(ObjectNode objectNode) {
        super(objectNode, IndexKind.SPATIAL);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public DataType getDataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(StringUtils.upperCase(this.jsonSerializable.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            this.jsonSerializable.getLogger().warn("INVALID index dataType value {}.", (Object)this.jsonSerializable.getString("dataType"));
        }
        return result;
    }

    public SpatialIndex setDataType(DataType dataType) {
        this.jsonSerializable.set("dataType", dataType.toString());
        return this;
    }
}

