/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.OfferAutoscaleSettings;
import com.azure.cosmos.implementation.Resource;
import java.time.OffsetDateTime;

public class ThroughputProperties {
    private final Offer offer;

    ThroughputProperties(Offer offer) {
        this.offer = offer;
    }

    public static ThroughputProperties createManualThroughput(int throughput) {
        return new ThroughputProperties(Offer.createManualOffer(throughput));
    }

    static ThroughputProperties createAutoscaledThroughput(int autoScaleMaxThroughput, int autoUpgradethroughputIncrementPercentage) {
        return new ThroughputProperties(Offer.createAutoscaleOffer(autoScaleMaxThroughput, autoUpgradethroughputIncrementPercentage));
    }

    public static ThroughputProperties createAutoscaledThroughput(int autoScaleMaxThroughput) {
        return new ThroughputProperties(Offer.createAutoscaleOffer(autoScaleMaxThroughput, 0));
    }

    public Integer getManualThroughput() {
        return this.offer.getThroughput();
    }

    OfferAutoscaleSettings getOfferAutoscaleProperties() {
        return this.offer.getOfferAutoScaleSettings();
    }

    public int getAutoscaleMaxThroughput() {
        return this.offer.getAutoscaleMaxThroughput();
    }

    Offer getOffer() {
        return this.offer;
    }

    Offer updateOfferFromProperties(Offer oldOffer) {
        oldOffer.updateContent(this.offer);
        return oldOffer;
    }

    Resource getResource() {
        return this.offer;
    }

    public String getId() {
        return this.offer.getId();
    }

    public ThroughputProperties setId(String id) {
        this.offer.setId(id);
        return this;
    }

    public String getResourceId() {
        return this.offer.getResourceId();
    }

    public OffsetDateTime getTimestamp() {
        return this.offer.getTimestamp();
    }

    public String getETag() {
        return this.offer.getETag();
    }
}

