/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncConflict;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncScripts;
import com.azure.cosmos.implementation.CosmosItemProperties;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.models.CosmosConflictProperties;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.QueryRequestOptions;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class CosmosAsyncContainer {
    private final CosmosAsyncDatabase database;
    private final String id;
    private final String link;
    private CosmosAsyncScripts scripts;

    CosmosAsyncContainer(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
        this.link = this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
    }

    public String getId() {
        return this.id;
    }

    public Mono<CosmosContainerResponse> read() {
        return this.read(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> read(CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().readCollection(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
    }

    public Mono<CosmosContainerResponse> delete(CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().deleteCollection(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
    }

    public Mono<CosmosContainerResponse> delete() {
        return this.delete(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> replace(CosmosContainerProperties containerProperties) {
        return this.replace(containerProperties, null);
    }

    public Mono<CosmosContainerResponse> replace(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().replaceCollection(ModelBridgeInternal.getV2Collection(containerProperties), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosContainerResponse(response)).single();
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item) {
        return this.createItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        return this.createItem(item, options);
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        Class<?> itemType = item.getClass();
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.database.getDocClientWrapper().createDocument(this.getLink(), item, requestOptions, true).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType)).single();
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item) {
        return this.upsertItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        Class<?> itemType = item.getClass();
        return this.getDatabase().getDocClientWrapper().upsertDocument(this.getLink(), item, ModelBridgeInternal.toRequestOptions(options), true).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType)).single();
    }

    <T> CosmosPagedFlux<T> readAllItems(Class<T> classType) {
        return this.readAllItems(new QueryRequestOptions(), classType);
    }

    <T> CosmosPagedFlux<T> readAllItems(QueryRequestOptions options, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDatabase().getDocClientWrapper().readDocuments(this.getLink(), options).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, classType));
        });
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, Class<T> classType) {
        return this.queryItems(new SqlQuerySpec(query), classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, QueryRequestOptions options, Class<T> classType) {
        return this.queryItems(new SqlQuerySpec(query), options, classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, Class<T> classType) {
        return this.queryItems(querySpec, new QueryRequestOptions(), classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, QueryRequestOptions options, Class<T> classType) {
        return this.queryItemsInternal(querySpec, options, classType);
    }

    private <T> CosmosPagedFlux<T> queryItemsInternal(SqlQuerySpec sqlQuerySpec, QueryRequestOptions queryRequestOptions, Class<T> classType) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, queryRequestOptions);
            return this.getDatabase().getDocClientWrapper().queryDocuments(this.getLink(), sqlQuerySpec, queryRequestOptions).map(response -> this.prepareFeedResponse((FeedResponse<Document>)response, classType));
        });
    }

    private <T> FeedResponse<T> prepareFeedResponse(FeedResponse<Document> response, Class<T> classType) {
        QueryInfo queryInfo = ModelBridgeInternal.getQueryInfoFromFeedResponse(response);
        if (queryInfo != null && queryInfo.hasSelectValue()) {
            List transformedResults = response.getResults().stream().map(d -> d.get("_value")).map(object -> this.transform(object, classType)).collect(Collectors.toList());
            return BridgeInternal.createFeedResponseWithQueryMetrics(transformedResults, response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response));
        }
        return BridgeInternal.createFeedResponseWithQueryMetrics(response.getResults().stream().map(document -> ModelBridgeInternal.toObjectFromJsonSerializable(document, classType)).collect(Collectors.toList()), response.getResponseHeaders(), ModelBridgeInternal.queryMetrics(response));
    }

    private <T> T transform(Object object, Class<T> classType) {
        return (T)Utils.getSimpleObjectMapper().convertValue(object, classType);
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, Class<T> itemType) {
        return this.readItem(itemId, partitionKey, ModelBridgeInternal.createCosmosItemRequestOptions(partitionKey), itemType);
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options, Class<T> itemType) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.getDatabase().getDocClientWrapper().readDocument(this.getItemLink(itemId), requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType)).single();
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey) {
        return this.replaceItem(item, itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        Document doc = CosmosItemProperties.fromObject(item);
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        Class<?> itemType = item.getClass();
        return this.getDatabase().getDocClientWrapper().replaceDocument(this.getItemLink(itemId), doc, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponse(response, itemType)).single();
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey) {
        return this.deleteItem(itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        ModelBridgeInternal.setPartitionKey(options, partitionKey);
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return this.getDatabase().getDocClientWrapper().deleteDocument(this.getItemLink(itemId), requestOptions).map(response -> ModelBridgeInternal.createCosmosAsyncItemResponseWithObjectType(response)).single();
    }

    private String getItemLink(String itemId) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLink());
        builder.append("/");
        builder.append("docs");
        builder.append("/");
        builder.append(itemId);
        return builder.toString();
    }

    public CosmosAsyncScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosAsyncScripts(this);
        }
        return this.scripts;
    }

    public CosmosPagedFlux<CosmosConflictProperties> readAllConflicts(QueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().readConflicts(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosConflictPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosConflictProperties> queryConflicts(String query) {
        return this.queryConflicts(query, new QueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosConflictProperties> queryConflicts(String query, QueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().queryConflicts(this.getLink(), query, options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosConflictPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosAsyncConflict getConflict(String id) {
        return new CosmosAsyncConflict(id, this);
    }

    public Mono<ThroughputResponse> replaceThroughput(ThroughputProperties throughputProperties) {
        return this.read().flatMap(response -> this.database.getDocClientWrapper().queryOffers(this.database.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), new QueryRequestOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosException(400, "No offers found for the resource " + this.getId())));
            }
            Offer existingOffer = (Offer)offerFeedResponse.getResults().get(0);
            Offer updatedOffer = ModelBridgeInternal.updateOfferFromProperties(existingOffer, throughputProperties);
            return this.database.getDocClientWrapper().replaceOffer(updatedOffer).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    public Mono<ThroughputResponse> readThroughput() {
        return this.read().flatMap(response -> this.database.getDocClientWrapper().queryOffers(this.database.getOfferQuerySpecFromResourceId(response.getProperties().getResourceId()), new QueryRequestOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)((Object)BridgeInternal.createCosmosException(400, "No offers found for the resource " + this.getId())));
            }
            return this.database.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(ModelBridgeInternal::createThroughputRespose));
    }

    public CosmosAsyncDatabase getDatabase() {
        return this.database;
    }

    String getURIPathSegment() {
        return "colls";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        return this.link;
    }
}

