/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncStoredProcedure;
import com.azure.cosmos.CosmosAsyncTrigger;
import com.azure.cosmos.CosmosAsyncUserDefinedFunction;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import com.azure.cosmos.models.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.models.CosmosStoredProcedureResponse;
import com.azure.cosmos.models.CosmosTriggerProperties;
import com.azure.cosmos.models.CosmosTriggerResponse;
import com.azure.cosmos.models.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.models.CosmosUserDefinedFunctionResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.QueryRequestOptions;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncScripts {
    private final CosmosAsyncContainer container;
    private final CosmosAsyncDatabase database;

    CosmosAsyncScripts(CosmosAsyncContainer container) {
        this.container = container;
        this.database = container.getDatabase();
    }

    public Mono<CosmosStoredProcedureResponse> createStoredProcedure(CosmosStoredProcedureProperties properties) {
        return this.createStoredProcedure(properties, new CosmosStoredProcedureRequestOptions());
    }

    public Mono<CosmosStoredProcedureResponse> createStoredProcedure(CosmosStoredProcedureProperties properties, CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        StoredProcedure sProc = new StoredProcedure();
        sProc.setId(properties.getId());
        sProc.setBody(properties.getBody());
        return this.database.getDocClientWrapper().createStoredProcedure(this.container.getLink(), sProc, ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosStoredProcedureResponse(response)).single();
    }

    public CosmosPagedFlux<CosmosStoredProcedureProperties> readAllStoredProcedures() {
        return this.readAllStoredProcedures(new QueryRequestOptions());
    }

    CosmosPagedFlux<CosmosStoredProcedureProperties> readAllStoredProcedures(QueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().readStoredProcedures(this.container.getLink(), options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosStoredProcedurePropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosStoredProcedureProperties> queryStoredProcedures(String query, QueryRequestOptions options) {
        return this.queryStoredProcedures(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosStoredProcedureProperties> queryStoredProcedures(SqlQuerySpec querySpec, QueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().queryStoredProcedures(this.container.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosStoredProcedurePropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosAsyncStoredProcedure getStoredProcedure(String id) {
        return new CosmosAsyncStoredProcedure(id, this.container);
    }

    public Mono<CosmosUserDefinedFunctionResponse> createUserDefinedFunction(CosmosUserDefinedFunctionProperties properties) {
        UserDefinedFunction udf = new UserDefinedFunction();
        udf.setId(properties.getId());
        udf.setBody(properties.getBody());
        return this.database.getDocClientWrapper().createUserDefinedFunction(this.container.getLink(), udf, null).map(response -> ModelBridgeInternal.createCosmosUserDefinedFunctionResponse(response)).single();
    }

    public CosmosPagedFlux<CosmosUserDefinedFunctionProperties> readAllUserDefinedFunctions() {
        return this.readAllUserDefinedFunctions(new QueryRequestOptions());
    }

    CosmosPagedFlux<CosmosUserDefinedFunctionProperties> readAllUserDefinedFunctions(QueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().readUserDefinedFunctions(this.container.getLink(), options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosUserDefinedFunctionPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosUserDefinedFunctionProperties> queryUserDefinedFunctions(String query, QueryRequestOptions options) {
        return this.queryUserDefinedFunctions(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosUserDefinedFunctionProperties> queryUserDefinedFunctions(SqlQuerySpec querySpec, QueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().queryUserDefinedFunctions(this.container.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosUserDefinedFunctionPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosAsyncUserDefinedFunction getUserDefinedFunction(String id) {
        return new CosmosAsyncUserDefinedFunction(id, this.container);
    }

    public Mono<CosmosTriggerResponse> createTrigger(CosmosTriggerProperties properties) {
        Trigger trigger = new Trigger(ModelBridgeInternal.toJsonFromJsonSerializable(ModelBridgeInternal.getResource(properties)));
        return this.database.getDocClientWrapper().createTrigger(this.container.getLink(), trigger, null).map(response -> ModelBridgeInternal.createCosmosTriggerResponse(response)).single();
    }

    public CosmosPagedFlux<CosmosTriggerProperties> readAllTriggers() {
        return this.readAllTriggers(new QueryRequestOptions());
    }

    CosmosPagedFlux<CosmosTriggerProperties> readAllTriggers(QueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().readTriggers(this.container.getLink(), options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosTriggerPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosTriggerProperties> queryTriggers(String query, QueryRequestOptions options) {
        return this.queryTriggers(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosTriggerProperties> queryTriggers(SqlQuerySpec querySpec, QueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().queryTriggers(this.container.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosTriggerPropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosAsyncTrigger getTrigger(String id) {
        return new CosmosAsyncTrigger(id, this.container);
    }
}

