/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.CosmosScripts;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.QueryRequestOptions;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.CosmosPagedIterable;
import com.azure.cosmos.util.UtilBridgeInternal;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosContainer {
    final CosmosAsyncContainer asyncContainer;
    private final CosmosDatabase database;
    private final String id;
    private CosmosScripts scripts;

    CosmosContainer(String id, CosmosDatabase database, CosmosAsyncContainer container) {
        this.id = id;
        this.database = database;
        this.asyncContainer = container;
    }

    public String getId() {
        return this.id;
    }

    public CosmosContainerResponse read() {
        return this.database.blockContainerResponse(this.asyncContainer.read());
    }

    public CosmosContainerResponse read(CosmosContainerRequestOptions options) {
        return this.database.blockContainerResponse(this.asyncContainer.read(options));
    }

    public CosmosContainerResponse delete(CosmosContainerRequestOptions options) {
        return this.database.blockContainerResponse(this.asyncContainer.delete(options));
    }

    public CosmosContainerResponse delete() {
        return this.database.blockContainerResponse(this.asyncContainer.delete());
    }

    public CosmosContainerResponse replace(CosmosContainerProperties containerProperties) {
        return this.database.blockContainerResponse(this.asyncContainer.replace(containerProperties));
    }

    public CosmosContainerResponse replace(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        return this.database.blockContainerResponse(this.asyncContainer.replace(containerProperties, options));
    }

    public ThroughputResponse replaceThroughput(ThroughputProperties throughputProperties) {
        return this.database.throughputResponseToBlock(this.asyncContainer.replaceThroughput(throughputProperties));
    }

    public ThroughputResponse readThroughput() {
        return this.database.throughputResponseToBlock(this.asyncContainer.readThroughput());
    }

    public <T> CosmosItemResponse<T> createItem(T item) {
        return this.blockItemResponse(this.asyncContainer.createItem(item));
    }

    public <T> CosmosItemResponse<T> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.asyncContainer.createItem(item, partitionKey, options));
    }

    public <T> CosmosItemResponse<T> createItem(T item, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.asyncContainer.createItem(item, options));
    }

    public <T> CosmosItemResponse<T> upsertItem(T item) {
        return this.blockItemResponse(this.asyncContainer.upsertItem(item));
    }

    public <T> CosmosItemResponse<T> upsertItem(T item, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.asyncContainer.upsertItem(item, options));
    }

    <T> CosmosItemResponse<T> blockItemResponse(Mono<CosmosItemResponse<T>> itemMono) {
        try {
            return (CosmosItemResponse)itemMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw ex;
        }
    }

    private CosmosItemResponse<Object> blockDeleteItemResponse(Mono<CosmosItemResponse<Object>> deleteItemMono) {
        try {
            return (CosmosItemResponse)deleteItemMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw ex;
        }
    }

    <T> CosmosPagedIterable<T> readAllItems(QueryRequestOptions options, Class<T> classType) {
        return this.getCosmosPagedIterable(this.asyncContainer.readAllItems(options, classType));
    }

    public <T> CosmosPagedIterable<T> queryItems(String query, QueryRequestOptions options, Class<T> classType) {
        return this.getCosmosPagedIterable(this.asyncContainer.queryItems(query, options, classType));
    }

    public <T> CosmosPagedIterable<T> queryItems(SqlQuerySpec querySpec, QueryRequestOptions options, Class<T> classType) {
        return this.getCosmosPagedIterable(this.asyncContainer.queryItems(querySpec, options, classType));
    }

    public <T> CosmosItemResponse<T> readItem(String itemId, PartitionKey partitionKey, Class<T> itemType) {
        return this.blockItemResponse(this.asyncContainer.readItem(itemId, partitionKey, new CosmosItemRequestOptions(), itemType));
    }

    public <T> CosmosItemResponse<T> readItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options, Class<T> itemType) {
        return this.blockItemResponse(this.asyncContainer.readItem(itemId, partitionKey, options, itemType));
    }

    public <T> CosmosItemResponse<T> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.asyncContainer.replaceItem(item, itemId, partitionKey, options));
    }

    public CosmosItemResponse<Object> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        return this.blockDeleteItemResponse(this.asyncContainer.deleteItem(itemId, partitionKey, options));
    }

    public CosmosScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosScripts(this, this.asyncContainer.getScripts());
        }
        return this.scripts;
    }

    private <T> CosmosPagedIterable<T> getCosmosPagedIterable(CosmosPagedFlux<T> cosmosPagedFlux) {
        return UtilBridgeInternal.createCosmosPagedIterable(cosmosPagedFlux);
    }
}

