/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.exception.AzureException;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CosmosException
extends AzureException {
    private static final long serialVersionUID = 1L;
    private static final String USER_AGENT = Utils.getUserAgent();
    private final int statusCode;
    private final Map<String, String> responseHeaders;
    private CosmosDiagnostics cosmosDiagnostics;
    private final RequestTimeline requestTimeline;
    private CosmosError cosmosError;
    long lsn;
    String partitionKeyRangeId;
    Map<String, String> requestHeaders;
    Uri requestUri;
    String resourceAddress;

    protected CosmosException(int statusCode, String message, Map<String, String> responseHeaders, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.requestTimeline = RequestTimeline.empty();
        this.responseHeaders = responseHeaders == null ? new HashMap<String, String>() : new HashMap<String, String>(responseHeaders);
    }

    CosmosException(int statusCode) {
        this(statusCode, null, null, null);
    }

    protected CosmosException(int statusCode, String errorMessage) {
        this(statusCode, errorMessage, null, null);
        this.cosmosError = new CosmosError();
        ModelBridgeInternal.setProperty(this.cosmosError, "message", errorMessage);
    }

    protected CosmosException(int statusCode, Exception innerException) {
        this(statusCode, null, null, innerException);
    }

    protected CosmosException(int statusCode, CosmosError cosmosErrorResource, Map<String, String> responseHeaders) {
        this(null, statusCode, cosmosErrorResource, responseHeaders);
    }

    protected CosmosException(String resourceAddress, int statusCode, CosmosError cosmosErrorResource, Map<String, String> responseHeaders) {
        this(statusCode, cosmosErrorResource == null ? null : cosmosErrorResource.getMessage(), responseHeaders, null);
        this.resourceAddress = resourceAddress;
        this.cosmosError = cosmosErrorResource;
    }

    protected CosmosException(String message, Exception exception, Map<String, String> responseHeaders, int statusCode, String resourceAddress) {
        this(statusCode, message, responseHeaders, exception);
        this.resourceAddress = resourceAddress;
    }

    public String getMessage() {
        if (this.cosmosDiagnostics == null) {
            return this.innerErrorMessage();
        }
        return this.innerErrorMessage() + ", " + this.cosmosDiagnostics.toString();
    }

    public String getActivityId() {
        if (this.responseHeaders != null) {
            return this.responseHeaders.get("x-ms-activity-id");
        }
        return null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getSubStatusCode() {
        String subStatusString;
        int code = 0;
        if (this.responseHeaders != null && StringUtils.isNotEmpty(subStatusString = this.responseHeaders.get("x-ms-substatus"))) {
            try {
                code = Integer.parseInt(subStatusString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return code;
    }

    CosmosError getError() {
        return this.cosmosError;
    }

    void setError(CosmosError cosmosError) {
        this.cosmosError = cosmosError;
    }

    public Duration getRetryAfterDuration() {
        String header;
        long retryIntervalInMilliseconds = 0L;
        if (this.responseHeaders != null && StringUtils.isNotEmpty(header = this.responseHeaders.get("x-ms-retry-after-ms"))) {
            try {
                retryIntervalInMilliseconds = Long.parseLong(header);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Duration.ofMillis(retryIntervalInMilliseconds);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    String getResourceAddress() {
        return this.resourceAddress;
    }

    public CosmosDiagnostics getDiagnostics() {
        return this.cosmosDiagnostics;
    }

    CosmosException setDiagnostics(CosmosDiagnostics cosmosDiagnostics) {
        this.cosmosDiagnostics = cosmosDiagnostics;
        return this;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{userAgent=" + USER_AGENT + ", error=" + this.cosmosError + ", resourceAddress='" + this.resourceAddress + '\'' + ", statusCode=" + this.statusCode + ", message=" + this.getMessage() + ", causeInfo=" + this.causeInfo() + ", responseHeaders=" + this.responseHeaders + ", requestHeaders=" + this.filterSensitiveData(this.requestHeaders) + '}';
    }

    String innerErrorMessage() {
        String innerErrorMessage = super.getMessage();
        if (this.cosmosError != null && (innerErrorMessage = this.cosmosError.getMessage()) == null) {
            innerErrorMessage = String.valueOf(ModelBridgeInternal.getObjectFromJsonSerializable(this.cosmosError, "Errors"));
        }
        return innerErrorMessage;
    }

    private String causeInfo() {
        Throwable cause = this.getCause();
        if (cause != null) {
            return String.format("[class: %s, message: %s]", cause.getClass(), cause.getMessage());
        }
        return null;
    }

    private List<Map.Entry<String, String>> filterSensitiveData(Map<String, String> requestHeaders) {
        if (requestHeaders == null) {
            return null;
        }
        return requestHeaders.entrySet().stream().filter(entry -> !"authorization".equalsIgnoreCase((String)entry.getKey())).collect(Collectors.toList());
    }

    void setResourceAddress(String resourceAddress) {
        this.resourceAddress = resourceAddress;
    }
}

