/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.ByteBufferOutputStream;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.HttpConstants;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceId;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RuntimeConstants;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.uuid.EthernetAddress;
import com.azure.cosmos.implementation.uuid.Generators;
import com.azure.cosmos.implementation.uuid.impl.TimeBasedGenerator;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.QueryRequestOptions;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class Utils {
    private static final int ONE_KB = 1024;
    private static final ZoneId GMT_ZONE_ID = ZoneId.of("GMT");
    public static final Base64.Encoder Base64Encoder = Base64.getEncoder();
    public static final Base64.Decoder Base64Decoder = Base64.getDecoder();
    private static final ObjectMapper simpleObjectMapper = new ObjectMapper();
    private static final TimeBasedGenerator TIME_BASED_GENERATOR = Generators.timeBasedGenerator(EthernetAddress.constructMulticastAddress());
    private static final DateTimeFormatter RFC_1123_DATE_TIME = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    public static byte[] getUTF8BytesOrNull(String str) {
        if (str == null) {
            return null;
        }
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] getUTF8Bytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static String encodeBase64String(byte[] binaryData) {
        String encodedString = Base64Encoder.encodeToString(binaryData);
        if (encodedString.endsWith("\r\n")) {
            encodedString = encodedString.substring(0, encodedString.length() - 2);
        }
        return encodedString;
    }

    public static boolean isNameBased(String link) {
        String[] parts;
        if (StringUtils.isEmpty(link)) {
            return false;
        }
        if (link.startsWith("/") && link.length() > 1) {
            link = link.substring(1);
        }
        if ((parts = StringUtils.split(link, "/")).length == 0 || StringUtils.isEmpty(parts[0]) || !parts[0].equalsIgnoreCase("dbs")) {
            return false;
        }
        if (parts.length < 2 || StringUtils.isEmpty(parts[1])) {
            return false;
        }
        String databaseID = parts[1];
        if (databaseID.length() != 8) {
            return true;
        }
        byte[] buffer = ResourceId.fromBase64String(databaseID);
        return buffer.length != 4;
    }

    public static boolean isDatabaseLink(String link) {
        if (StringUtils.isEmpty(link)) {
            return false;
        }
        String[] parts = StringUtils.split(link = Utils.trimBeginningAndEndingSlashes(link), "/");
        if (parts.length != 2) {
            return false;
        }
        if (StringUtils.isEmpty(parts[0]) || !parts[0].equalsIgnoreCase("dbs")) {
            return false;
        }
        return !StringUtils.isEmpty(parts[1]);
    }

    public static String joinPath(String path1, String path2) {
        path1 = Utils.trimBeginningAndEndingSlashes(path1);
        String result = "/" + path1 + "/";
        if (!StringUtils.isEmpty(path2)) {
            path2 = Utils.trimBeginningAndEndingSlashes(path2);
            result = result + path2 + "/";
        }
        return result;
    }

    public static String trimBeginningAndEndingSlashes(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static Map<String, String> paramEncode(Map<String, String> queryParams) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> paramEntry : queryParams.entrySet()) {
            try {
                map.put(paramEntry.getKey(), URLEncoder.encode(paramEntry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return map;
    }

    public static String createQuery(Map<String, String> queryParameters) {
        if (queryParameters == null) {
            return "";
        }
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, String> nameValuePair : queryParameters.entrySet()) {
            String key = nameValuePair.getKey();
            String value = nameValuePair.getValue();
            if (key == null || key.isEmpty()) continue;
            if (queryString.length() > 0) {
                queryString.append(RuntimeConstants.Separators.Query[1]);
            }
            queryString.append(key);
            if (value == null) continue;
            queryString.append(RuntimeConstants.Separators.Query[2]);
            queryString.append(value);
        }
        return queryString.toString();
    }

    public static URI setQuery(String urlString, String query) {
        if (urlString == null) {
            throw new IllegalStateException("urlString parameter can't be null.");
        }
        query = Utils.removeLeadingQuestionMark(query);
        try {
            if (query != null && !query.isEmpty()) {
                return new URI(Utils.addTrailingSlash(urlString) + RuntimeConstants.Separators.Query[0] + query);
            }
            return new URI(Utils.addTrailingSlash(urlString));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Uri is invalid: ", e);
        }
    }

    public static String getCollectionName(String resourceFullName) {
        if (resourceFullName != null) {
            resourceFullName = Utils.trimBeginningAndEndingSlashes(resourceFullName);
            int slashCount = 0;
            for (int i = 0; i < resourceFullName.length(); ++i) {
                if (resourceFullName.charAt(i) != '/' || ++slashCount != 4) continue;
                return resourceFullName.substring(0, i);
            }
        }
        return resourceFullName;
    }

    public static <T> int getCollectionSize(Collection<T> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static Boolean isCollectionPartitioned(DocumentCollection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("collection");
        }
        return collection.getPartitionKey() != null && collection.getPartitionKey().getPaths() != null && collection.getPartitionKey().getPaths().size() > 0;
    }

    public static boolean isCollectionChild(ResourceType type) {
        return type == ResourceType.Document || type == ResourceType.Attachment || type == ResourceType.Conflict || type == ResourceType.StoredProcedure || type == ResourceType.Trigger || type == ResourceType.UserDefinedFunction;
    }

    public static boolean isWriteOperation(OperationType operationType) {
        return operationType == OperationType.Create || operationType == OperationType.Upsert || operationType == OperationType.Delete || operationType == OperationType.Replace || operationType == OperationType.ExecuteJavaScript;
    }

    public static boolean isFeedRequest(OperationType requestOperationType) {
        return requestOperationType == OperationType.Create || requestOperationType == OperationType.Upsert || requestOperationType == OperationType.ReadFeed || requestOperationType == OperationType.Query || requestOperationType == OperationType.SqlQuery || requestOperationType == OperationType.HeadFeed;
    }

    private static String addTrailingSlash(String path) {
        if (path == null || path.isEmpty()) {
            path = new String(RuntimeConstants.Separators.Url);
        } else if (path.charAt(path.length() - 1) != RuntimeConstants.Separators.Url[0]) {
            path = path + RuntimeConstants.Separators.Url[0];
        }
        return path;
    }

    private static String removeLeadingQuestionMark(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == RuntimeConstants.Separators.Query[0]) {
            return path.substring(1);
        }
        return path;
    }

    public static boolean isValidConsistency(ConsistencyLevel backendConsistency, ConsistencyLevel desiredConsistency) {
        switch (backendConsistency) {
            case STRONG: {
                return desiredConsistency == ConsistencyLevel.STRONG || desiredConsistency == ConsistencyLevel.BOUNDED_STALENESS || desiredConsistency == ConsistencyLevel.SESSION || desiredConsistency == ConsistencyLevel.EVENTUAL || desiredConsistency == ConsistencyLevel.CONSISTENT_PREFIX;
            }
            case BOUNDED_STALENESS: {
                return desiredConsistency == ConsistencyLevel.BOUNDED_STALENESS || desiredConsistency == ConsistencyLevel.SESSION || desiredConsistency == ConsistencyLevel.EVENTUAL || desiredConsistency == ConsistencyLevel.CONSISTENT_PREFIX;
            }
            case SESSION: 
            case EVENTUAL: 
            case CONSISTENT_PREFIX: {
                return desiredConsistency == ConsistencyLevel.SESSION || desiredConsistency == ConsistencyLevel.EVENTUAL || desiredConsistency == ConsistencyLevel.CONSISTENT_PREFIX;
            }
        }
        throw new IllegalArgumentException("backendConsistency");
    }

    public static String getUserAgent() {
        return Utils.getUserAgent("cosmosdb-java-sdk", HttpConstants.Versions.SDK_VERSION);
    }

    public static String getUserAgent(String sdkName, String sdkVersion) {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            osName = "Unknown";
        }
        osName = osName.replaceAll("\\s", "");
        String userAgent = String.format("%s/%s JRE/%s %s/%s", osName, System.getProperty("os.version"), System.getProperty("java.version"), sdkName, sdkVersion);
        return userAgent;
    }

    public static ObjectMapper getSimpleObjectMapper() {
        return simpleObjectMapper;
    }

    public static String nowAsRFC1123() {
        ZonedDateTime now = ZonedDateTime.now(GMT_ZONE_ID);
        return RFC_1123_DATE_TIME.format(now);
    }

    public static UUID randomUUID() {
        return TIME_BASED_GENERATOR.generate();
    }

    public static String zonedDateTimeAsUTCRFC1123(OffsetDateTime offsetDateTime) {
        return RFC_1123_DATE_TIME.format(offsetDateTime.atZoneSameInstant(GMT_ZONE_ID));
    }

    public static int getValueOrDefault(Integer val, int defaultValue) {
        return val != null ? val : defaultValue;
    }

    public static void checkStateOrThrow(boolean value, String argumentName, String message) throws IllegalArgumentException {
        IllegalArgumentException t = Utils.checkStateOrReturnException(value, argumentName, message);
        if (t != null) {
            throw t;
        }
    }

    public static void checkNotNullOrThrow(Object val, String argumentName, String message) throws NullPointerException {
        NullPointerException t = Utils.checkNotNullOrReturnException(val, argumentName, message, new Object[0]);
        if (t != null) {
            throw t;
        }
    }

    public static void checkStateOrThrow(boolean value, String argumentName, String messageTemplate, Object ... messageTemplateParams) throws IllegalArgumentException {
        IllegalArgumentException t = Utils.checkStateOrReturnException(value, argumentName, argumentName, messageTemplateParams);
        if (t != null) {
            throw t;
        }
    }

    public static IllegalArgumentException checkStateOrReturnException(boolean value, String argumentName, String message) {
        if (value) {
            return null;
        }
        return new IllegalArgumentException(String.format("argumentName: %s, message: %s", argumentName, message));
    }

    public static IllegalArgumentException checkStateOrReturnException(boolean value, String argumentName, String messageTemplate, Object ... messageTemplateParams) {
        if (value) {
            return null;
        }
        return new IllegalArgumentException(String.format("argumentName: %s, message: %s", argumentName, String.format(messageTemplate, messageTemplateParams)));
    }

    private static NullPointerException checkNotNullOrReturnException(Object val, String argumentName, String messageTemplate, Object ... messageTemplateParams) {
        if (val != null) {
            return null;
        }
        return new NullPointerException(String.format("argumentName: %s, message: %s", argumentName, String.format(messageTemplate, messageTemplateParams)));
    }

    public static BadRequestException checkRequestOrReturnException(boolean value, String argumentName, String message) {
        if (value) {
            return null;
        }
        return new BadRequestException(String.format("argumentName: %s, message: %s", argumentName, message));
    }

    public static BadRequestException checkRequestOrReturnException(boolean value, String argumentName, String messageTemplate, Object ... messageTemplateParams) {
        if (value) {
            return null;
        }
        return new BadRequestException(String.format("argumentName: %s, message: %s", argumentName, String.format(messageTemplate, messageTemplateParams)));
    }

    public static <O, I> O as(I i, Class<O> klass) {
        if (i == null) {
            return null;
        }
        if (klass.isInstance(i)) {
            return (O)i;
        }
        return null;
    }

    public static <V> List<V> immutableListOf() {
        return Collections.EMPTY_LIST;
    }

    public static <V> List<V> immutableListOf(V v1) {
        ArrayList<V> list = new ArrayList<V>();
        list.add(v1);
        return Collections.unmodifiableList(list);
    }

    public static <K, V> Map<K, V> immutableMapOf() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1) {
        Map<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map = Collections.unmodifiableMap(map);
        return map;
    }

    public static <V> V firstOrDefault(List<V> list) {
        return list.size() > 0 ? (V)list.get(0) : null;
    }

    public static <K, V> boolean tryGetValue(Map<K, V> dictionary, K key, ValueHolder<V> holder) {
        holder.v = dictionary.get(key);
        return holder.v != null;
    }

    public static <K, V> boolean tryRemove(Map<K, V> dictionary, K key, ValueHolder<V> holder) {
        holder.v = dictionary.remove(key);
        return holder.v != null;
    }

    public static <T> T parse(String itemResponseBodyAsString, Class<T> itemClassType) {
        if (StringUtils.isEmpty(itemResponseBodyAsString)) {
            return null;
        }
        try {
            return (T)Utils.getSimpleObjectMapper().readValue(itemResponseBodyAsString, itemClassType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get POJO.", e);
        }
    }

    public static <T> T parse(byte[] item, Class<T> itemClassType) {
        if (Utils.isEmpty(item)) {
            return null;
        }
        try {
            return (T)Utils.getSimpleObjectMapper().readValue(item, itemClassType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get POJO.", e);
        }
    }

    public static ByteBuffer serializeJsonToByteBuffer(ObjectMapper objectMapper, Object object) {
        try {
            ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(1024);
            objectMapper.writeValue((OutputStream)byteBufferOutputStream, object);
            return byteBufferOutputStream.asByteBuffer();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to serialize the object into json", e);
        }
    }

    public static boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static String utf8StringFromOrNull(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void setContinuationTokenAndMaxItemCount(CosmosPagedFluxOptions pagedFluxOptions, QueryRequestOptions queryRequestOptions) {
        if (pagedFluxOptions == null) {
            return;
        }
        if (pagedFluxOptions.getRequestContinuation() != null) {
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(queryRequestOptions, pagedFluxOptions.getRequestContinuation());
        }
        if (pagedFluxOptions.getMaxItemCount() != null) {
            ModelBridgeInternal.setQueryRequestOptionsMaxItemCount(queryRequestOptions, pagedFluxOptions.getMaxItemCount());
        }
    }

    static String escapeNonAscii(String partitionKeyJson) {
        StringBuilder sb = null;
        for (int i = 0; i < partitionKeyJson.length(); ++i) {
            char val = partitionKeyJson.charAt(i);
            if (val > '\u007f') {
                if (sb == null) {
                    sb = new StringBuilder(partitionKeyJson.length());
                    sb.append(partitionKeyJson, 0, i);
                }
                sb.append("\\u").append(String.format("%04X", val));
                continue;
            }
            if (sb == null) continue;
            sb.append(partitionKeyJson.charAt(i));
        }
        if (sb == null) {
            return partitionKeyJson;
        }
        return sb.toString();
    }

    static byte[] toByteArray(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return bytes;
    }

    public static String toJson(ObjectMapper mapper, ObjectNode object) {
        try {
            return mapper.writeValueAsString((Object)object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to convert JSON to STRING", e);
        }
    }

    static {
        simpleObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        simpleObjectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        simpleObjectMapper.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true);
        simpleObjectMapper.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
        simpleObjectMapper.configure(DeserializationFeature.ACCEPT_FLOAT_AS_INT, false);
        simpleObjectMapper.registerModule((Module)new AfterburnerModule());
    }

    public static class ValueHolder<V> {
        public V v;

        public ValueHolder() {
        }

        public ValueHolder(V v) {
            this.v = v;
        }

        public static <T> ValueHolder<T> initialize(T v) {
            return new ValueHolder<T>(v);
        }
    }
}

