/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.DistinctContinuationToken;
import com.azure.cosmos.implementation.query.DistinctMap;
import com.azure.cosmos.implementation.query.DistinctQueryType;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class DistinctDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionComponent<T> {
    private final IDocumentQueryExecutionComponent<T> component;
    private final DistinctMap distinctMap;
    private final AtomicReference<String> lastHash;

    private DistinctDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, DistinctQueryType distinctQueryType, String previousHash) {
        if (distinctQueryType == DistinctQueryType.NONE) {
            throw new IllegalArgumentException("Invalid distinct query type");
        }
        if (component == null) {
            throw new IllegalArgumentException("documentQueryExecutionComponent cannot be null");
        }
        this.component = component;
        this.distinctMap = DistinctMap.create(distinctQueryType, previousHash);
        this.lastHash = new AtomicReference();
    }

    public static <T extends Resource> Flux<IDocumentQueryExecutionComponent<T>> createAsync(Function<String, Flux<IDocumentQueryExecutionComponent<T>>> createSourceComponentFunction, DistinctQueryType distinctQueryType, String continuationToken) {
        Utils.ValueHolder<DistinctContinuationToken> outDistinctcontinuationtoken = new Utils.ValueHolder<DistinctContinuationToken>();
        DistinctContinuationToken distinctContinuationToken = new DistinctContinuationToken(null, null);
        if (continuationToken != null) {
            if (!DistinctContinuationToken.tryParse(continuationToken, outDistinctcontinuationtoken)) {
                return Flux.error((Throwable)((Object)new BadRequestException("Invalid DistinctContinuationToken" + continuationToken)));
            }
            distinctContinuationToken = (DistinctContinuationToken)outDistinctcontinuationtoken.v;
            if (distinctQueryType != DistinctQueryType.ORDERED && distinctContinuationToken.getLastHash() != null) {
                BadRequestException dce = new BadRequestException("DistinctContinuationToken is malformed. DistinctContinuationToken can not have a 'lastHash', when the query type is not ordered (ex SELECT DISTINCT VALUE c.blah FROM c ORDER BY c.blah).");
                return Flux.error((Throwable)((Object)dce));
            }
        }
        String continuationTokenLastHash = distinctContinuationToken.getLastHash();
        return createSourceComponentFunction.apply(distinctContinuationToken.getSourceToken()).map(component -> new DistinctDocumentQueryExecutionContext(component, distinctQueryType, continuationTokenLastHash));
    }

    IDocumentQueryExecutionComponent<T> getComponent() {
        return this.component;
    }

    @Override
    public Flux<FeedResponse<T>> drainAsync(int maxPageSize) {
        return this.component.drainAsync(maxPageSize).map(tFeedResponse -> {
            ArrayList distinctResults = new ArrayList();
            tFeedResponse.getResults().forEach(document -> {
                Utils.ValueHolder<String> outHash = new Utils.ValueHolder<String>();
                if (this.distinctMap.add((Resource)document, outHash)) {
                    distinctResults.add(document);
                    this.lastHash.set((String)outHash.v);
                }
            });
            HashMap<String, String> headers = new HashMap<String, String>(tFeedResponse.getResponseHeaders());
            if (tFeedResponse.getContinuationToken() != null) {
                String sourceContinuationToken = tFeedResponse.getContinuationToken();
                DistinctContinuationToken distinctContinuationToken = new DistinctContinuationToken(this.lastHash.get(), sourceContinuationToken);
                headers.put("x-ms-continuation", ModelBridgeInternal.toJsonFromJsonSerializable(distinctContinuationToken));
            }
            return BridgeInternal.createFeedResponseWithQueryMetrics(distinctResults, headers, BridgeInternal.queryMetricsFromFeedResponse(tFeedResponse));
        });
    }
}

