/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.query.DefaultDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfo;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.QueryPlanRetriever;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.QueryRequestOptions;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DocumentQueryExecutionContextFactory {
    private static final int PageSizeFactorForTop = 5;

    private static Mono<Utils.ValueHolder<DocumentCollection>> resolveCollection(IDocumentQueryClient client, SqlQuerySpec query, ResourceType resourceTypeEnum, String resourceLink) {
        RxCollectionCache collectionCache = client.getCollectionCache();
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Query, resourceTypeEnum, resourceLink, null);
        return collectionCache.resolveCollectionAsync(null, request);
    }

    public static <T extends Resource> Flux<? extends IDocumentQueryExecutionContext<T>> createDocumentQueryExecutionContextAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, QueryRequestOptions queryRequestOptions, String resourceLink, boolean isContinuationExpected, UUID correlatedActivityId) {
        Flux collectionObs = Flux.just(new Utils.ValueHolder<Object>(null));
        if (resourceTypeEnum.isCollectionChild()) {
            collectionObs = DocumentQueryExecutionContextFactory.resolveCollection(client, query, resourceTypeEnum, resourceLink).flux();
        }
        DefaultDocumentQueryExecutionContext queryExecutionContext = new DefaultDocumentQueryExecutionContext(client, resourceTypeEnum, resourceType, query, queryRequestOptions, resourceLink, correlatedActivityId, isContinuationExpected);
        if (ResourceType.Document != resourceTypeEnum) {
            return Flux.just(queryExecutionContext);
        }
        Mono<PartitionedQueryExecutionInfo> queryExecutionInfoMono = QueryPlanRetriever.getQueryPlanThroughGatewayAsync(client, query, resourceLink);
        return collectionObs.single().flatMap(collectionValueHolder -> queryExecutionInfoMono.flatMap(partitionedQueryExecutionInfo -> {
            Mono<List<PartitionKeyRange>> partitionKeyRanges;
            QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
            if (queryRequestOptions != null && !StringUtils.isEmpty(ModelBridgeInternal.partitionKeyRangeIdInternal(queryRequestOptions))) {
                partitionKeyRanges = queryExecutionContext.getTargetPartitionKeyRangesById(((DocumentCollection)collectionValueHolder.v).getResourceId(), ModelBridgeInternal.partitionKeyRangeIdInternal(queryRequestOptions));
            } else {
                List<Range<String>> queryRanges = partitionedQueryExecutionInfo.getQueryRanges();
                if (queryRequestOptions != null && queryRequestOptions.getPartitionKey() != null && queryRequestOptions.getPartitionKey() != PartitionKey.NONE) {
                    PartitionKeyInternal internalPartitionKey = BridgeInternal.getPartitionKeyInternal(queryRequestOptions.getPartitionKey());
                    Range<String> range = Range.getPointRange(internalPartitionKey.getEffectivePartitionKeyString(internalPartitionKey, ((DocumentCollection)collectionValueHolder.v).getPartitionKey()));
                    queryRanges = Collections.singletonList(range);
                }
                partitionKeyRanges = queryExecutionContext.getTargetPartitionKeyRanges(((DocumentCollection)collectionValueHolder.v).getResourceId(), queryRanges);
            }
            return partitionKeyRanges.flatMap(pkranges -> DocumentQueryExecutionContextFactory.createSpecializedDocumentQueryExecutionContextAsync(client, resourceTypeEnum, resourceType, query, queryRequestOptions, resourceLink, isContinuationExpected, partitionedQueryExecutionInfo, pkranges, ((DocumentCollection)collectionValueHolder.v).getResourceId(), correlatedActivityId).single());
        })).flux();
    }

    public static <T extends Resource> Flux<? extends IDocumentQueryExecutionContext<T>> createSpecializedDocumentQueryExecutionContextAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, QueryRequestOptions queryRequestOptions, String resourceLink, boolean isContinuationExpected, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, String collectionRid, UUID correlatedActivityId) {
        int top;
        int initialPageSize = Utils.getValueOrDefault(ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(queryRequestOptions), 100);
        BadRequestException validationError = Utils.checkRequestOrReturnException(initialPageSize > 0 || initialPageSize == -1, "MaxItemCount", "Invalid MaxItemCount %s", initialPageSize);
        if (validationError != null) {
            return Flux.error((Throwable)((Object)validationError));
        }
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        boolean getLazyFeedResponse = queryInfo.hasTop();
        if (queryInfo.hasOrderBy() && queryInfo.hasTop() && (top = partitionedQueryExecutionInfo.getQueryInfo().getTop().intValue()) > 0) {
            int pageSizeWithTop = Math.min((int)Math.ceil((double)top / (double)targetRanges.size()) * 5, top);
            initialPageSize = initialPageSize > 0 ? Math.min(pageSizeWithTop, initialPageSize) : pageSizeWithTop;
        }
        return PipelinedDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, query, queryRequestOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
    }

    public static <T extends Resource> Flux<? extends IDocumentQueryExecutionContext<T>> createReadManyQueryAsync(IDocumentQueryClient queryClient, String collectionResourceId, SqlQuerySpec sqlQuery, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, QueryRequestOptions queryRequestOptions, String resourceId, String collectionLink, UUID activityId, Class<T> klass, ResourceType resourceTypeEnum) {
        return PipelinedDocumentQueryExecutionContext.createReadManyAsync(queryClient, collectionResourceId, sqlQuery, rangeQueryMap, queryRequestOptions, resourceId, collectionLink, activityId, klass, resourceTypeEnum);
    }
}

