/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.ChangeFeedOptions;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.query.Fetcher;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.QueryRequestOptions;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Paginator {
    private static final Logger logger = LoggerFactory.getLogger(Paginator.class);

    public static <T extends Resource> Flux<FeedResponse<T>> getPaginatedChangeFeedQueryResultAsObservable(ChangeFeedOptions feedOptions, BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, Class<T> resourceType, int maxPageSize) {
        return Paginator.getPaginatedQueryResultAsObservable(feedOptions.getRequestContinuation(), createRequestFunc, executeFunc, resourceType, -1, maxPageSize, true);
    }

    public static <T extends Resource> Flux<FeedResponse<T>> getPaginatedQueryResultAsObservable(QueryRequestOptions queryRequestOptions, BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, Class<T> resourceType, int maxPageSize) {
        return Paginator.getPaginatedQueryResultAsObservable(ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(queryRequestOptions), createRequestFunc, executeFunc, resourceType, -1, maxPageSize);
    }

    public static <T extends Resource> Flux<FeedResponse<T>> getPaginatedQueryResultAsObservable(String continuationToken, BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, Class<T> resourceType, int top, int maxPageSize) {
        return Paginator.getPaginatedQueryResultAsObservable(continuationToken, createRequestFunc, executeFunc, resourceType, top, maxPageSize, false);
    }

    private static <T extends Resource> Flux<FeedResponse<T>> getPaginatedQueryResultAsObservable(String continuationToken, BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, Class<T> resourceType, int top, int maxPageSize, boolean isChangeFeed) {
        return Flux.defer(() -> {
            Flux generate = Flux.generate(() -> new Fetcher(createRequestFunc, executeFunc, continuationToken, isChangeFeed, top, maxPageSize), (tFetcher, sink) -> {
                if (tFetcher.shouldFetchMore()) {
                    Mono nextPage = tFetcher.nextPage();
                    sink.next((Object)nextPage.flux());
                } else {
                    logger.debug("No more results");
                    sink.complete();
                }
                return tFetcher;
            });
            return generate.flatMapSequential(feedResponseFlux -> feedResponseFlux, 1);
        });
    }
}

